/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.BetterChairsCommand;
import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairNMS;
import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.EventListener;
import de.sprax2013.betterchairs.Messages;
import de.sprax2013.betterchairs.PlaceholderApiExpansion;
import de.sprax2013.betterchairs.Settings;
import de.sprax2013.betterchairs.Updater;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.LimeDevUtilitySpigot;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.spigot.nms.NmsVersionDetector;
import de.sprax2013.betterchairs.third_party.de.tr7zw.nbtapi.utils.MinecraftVersion;
import de.sprax2013.betterchairs.third_party.org.bstats.bukkit.Metrics;
import de.sprax2013.betterchairs.third_party.org.bstats.charts.SimplePie;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.material.Stairs;
import org.bukkit.material.Step;
import org.bukkit.material.WoodenStep;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BetterChairsPlugin
extends JavaPlugin {
    private static BetterChairsPlugin plugin;
    private static ChairManager chairManager;

    public void onEnable() {
        plugin = this;
        LimeDevUtilitySpigot.init(this);
        MinecraftVersion.disableUpdateCheck();
        MinecraftVersion.getLogger().setLevel(Level.WARNING);
        ChairNMS chairNMS = this.getNewNMSInstance();
        if (chairNMS.getListener() != null) {
            Bukkit.getPluginManager().registerEvents(chairNMS.getListener(), (Plugin)this);
        }
        chairManager = new ChairManager(this, chairNMS);
        Settings.reload();
        Messages.reload();
        new Updater(this);
        Bukkit.getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        BetterChairsCommand cmdExecutor = new BetterChairsCommand(this);
        this.getCommand(this.getName()).setExecutor((CommandExecutor)cmdExecutor);
        this.getCommand("toggleChairs").setExecutor((CommandExecutor)cmdExecutor);
        this.getCommand("sit").setExecutor((CommandExecutor)cmdExecutor);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderApiExpansion(this).register();
        }
        try {
            Metrics bStats = new Metrics((Plugin)this, 8214);
            String nmsVersion = NmsVersionDetector.detect().orElse(Bukkit.getServer().getBukkitVersion());
            bStats.addCustomChart(new SimplePie("nms_version", () -> nmsVersion));
        }
        catch (Exception ex) {
            this.getLogger().warning("Could not load bStats (" + ex.getClass().getSimpleName() + "): " + ex.getMessage());
        }
    }

    public void onDisable() {
        if (BetterChairsPlugin.getManager() != null) {
            BetterChairsPlugin.getManager().destroyAll(true, true);
            for (Player online : Bukkit.getOnlinePlayers()) {
                BetterChairsPlugin.getManager().onQuit(online.getUniqueId());
            }
            Settings.reset();
            Messages.reset();
        }
        chairManager = null;
        ChairManager.instance = null;
        ChairManager.plugin = null;
    }

    @NotNull
    private ChairNMS getNewNMSInstance() {
        String version = NmsVersionDetector.detect().orElse(null);
        try {
            assert (version != null);
            return (ChairNMS)Class.forName("de.sprax2013.betterchairs.nms." + version + "." + version).getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception ignore) {
            this.getLogger().warning("Your server version (" + (version != null ? version : "UNKNOWN") + ") is not fully supported - Loading fallback...");
            return new ChairNMS(){

                @Override
                @NotNull
                public Entity spawnChairEntity(@NotNull Location loc, int regenerationAmplifier, boolean useArmorStand) {
                    Entity chairEntity = useArmorStand ? loc.getWorld().spawn(loc, ArmorStand.class) : loc.getWorld().spawn(loc, Arrow.class);
                    ChairUtils.applyChairProtections(chairEntity);
                    return chairEntity;
                }

                @Override
                public void killChairEntity(@NotNull Entity entity) {
                    entity.remove();
                }

                @Override
                public Listener getListener() {
                    return new Listener(){

                        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
                        private void onManipulate(PlayerArmorStandManipulateEvent e) {
                            if (BetterChairsPlugin.getManager().isChair((Entity)e.getRightClicked())) {
                                e.setCancelled(true);
                            }
                        }

                        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
                        private void onDamage(EntityDamageEvent e) {
                            if (e.getEntity() instanceof ArmorStand && BetterChairsPlugin.getManager().isChair(e.getEntity())) {
                                e.setCancelled(true);
                            }
                        }
                    };
                }

                @Override
                public boolean isStair(@NotNull Block block) {
                    return block.getState().getData() instanceof Stairs;
                }

                @Override
                public boolean isStairUpsideDown(@NotNull Block block) {
                    try {
                        return ((Stairs)block.getState().getData()).isInverted();
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                @NotNull
                public BlockFace getBlockRotation(@NotNull Block block) {
                    return ChairUtils.getBlockRotationLegacy(block);
                }

                @Override
                public boolean isSlab(@NotNull Block block) {
                    return (block.getState().getData() instanceof Step || block.getState().getData() instanceof WoodenStep) && !block.getType().name().equals("DOUBLE_STEP") && !block.getType().name().equals("WOOD_DOUBLE_STEP");
                }

                @Override
                public boolean isSlabTop(@NotNull Block block) {
                    if (block.getState().getData() instanceof Step) {
                        return ((Step)block.getState().getData()).isInverted();
                    }
                    if (block.getState().getData() instanceof WoodenStep) {
                        return ((WoodenStep)block.getState().getData()).isInverted();
                    }
                    return false;
                }

                @Override
                public boolean hasEmptyMainHand(@NotNull Player player) {
                    return player.getInventory().getItemInHand().getType() == Material.AIR;
                }

                @Override
                public boolean isChair(@NotNull Entity entity) {
                    return false;
                }
            };
        }
    }

    protected static ChairManager getManager() {
        return chairManager;
    }

    public static BetterChairsPlugin getInstance() {
        return plugin;
    }
}

