/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.ChairType;
import de.sprax2013.betterchairs.Settings;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Chair {
    private static final String ERR_MANAGER_NOT_AVAILABLE = "ChairManager is not available yet - Did BetterChairs successfully enable?";
    protected final Block block;
    protected final Entity chairEntity;
    protected final Player player;
    private final Location playerOriginalLoc;

    Chair(Block block, Entity chairEntity, Player player) {
        this.block = block;
        this.chairEntity = chairEntity;
        this.player = player;
        this.playerOriginalLoc = player.getLocation();
    }

    @Deprecated
    public boolean isStair() {
        if (ChairManager.getInstance() == null) {
            throw new IllegalStateException(ERR_MANAGER_NOT_AVAILABLE);
        }
        return ChairManager.getInstance().chairNMS.isStair(this.block);
    }

    @NotNull
    public ChairType getType() {
        if (ChairManager.getInstance() == null) {
            throw new IllegalStateException(ERR_MANAGER_NOT_AVAILABLE);
        }
        if (ChairManager.getInstance().chairNMS.isStair(this.block)) {
            return ChairType.STAIR;
        }
        if (ChairManager.getInstance().chairNMS.isSlab(this.block)) {
            return ChairType.SLAB;
        }
        return ChairType.CUSTOM;
    }

    @NotNull
    public Location getOriginPlayerLocation() {
        return this.playerOriginalLoc.clone();
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    @NotNull
    public Entity getChairEntity() {
        return this.chairEntity;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Location getPlayerLeavingLocation() {
        Location loc = Settings.LEAVING_CHAIR_TELEPORT_TO_OLD_LOCATION.getValueAsBoolean() ? this.playerOriginalLoc.clone() : this.block.getRelative(BlockFace.UP).getLocation().add(0.5, 0.0, 0.5);
        if (Settings.LEAVING_CHAIR_KEEP_HEAD_ROTATION.getValueAsBoolean()) {
            loc.setDirection(this.player.getLocation().getDirection());
        }
        return loc;
    }

    protected boolean destroyOnNoPassenger() {
        if (this.chairEntity.getPassenger() == null) {
            if (ChairManager.getInstance() == null) {
                throw new IllegalStateException(ERR_MANAGER_NOT_AVAILABLE);
            }
            ChairManager.getInstance().destroy(this, true);
            return true;
        }
        return false;
    }
}

