/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.Chair;
import de.sprax2013.betterchairs.ChairNMS;
import de.sprax2013.betterchairs.ChairType;
import de.sprax2013.betterchairs.ChairUtils;
import de.sprax2013.betterchairs.Settings;
import de.sprax2013.betterchairs.events.PlayerEnterChairEvent;
import de.sprax2013.betterchairs.events.PlayerLeaveChairEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChairManager {
    protected static JavaPlugin plugin;
    protected static ChairManager instance;
    protected final ChairNMS chairNMS;
    protected final List<Chair> chairs = new ArrayList<Chair>();
    protected final HashMap<UUID, Boolean> disabled = new HashMap();
    protected final File disabledForDir;

    protected ChairManager(@NotNull JavaPlugin plugin, @NotNull ChairNMS chairNMS) {
        this.chairNMS = Objects.requireNonNull(chairNMS);
        this.disabledForDir = new File(plugin.getDataFolder(), "disabled_for");
        ChairManager.plugin = Objects.requireNonNull(plugin);
        instance = this;
    }

    protected void onQuit(UUID uuid) {
        Boolean value = this.disabled.remove(uuid);
        if (value != null && Settings.REMEMBER_IF_PLAYER_DISABLED_CHAIRS.getValueAsBoolean()) {
            Path path = new File(this.disabledForDir, uuid.toString()).toPath();
            try {
                if (value.booleanValue()) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.createFile(path, new FileAttribute[0]);
                } else {
                    Files.deleteIfExists(path);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.disabled.remove(uuid);
    }

    public boolean create(Player player, Block block) {
        return this.create(player, block, ChairUtils.getSitOffset(block, !Settings.SIT_ON_ARROWS.getValueAsBoolean(), this.chairNMS));
    }

    public boolean create(Player player, Block block, double yOffset) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        if (this.isOccupied(block)) {
            return false;
        }
        Entity chairEntity = ChairManager.instance.chairNMS.spawnChairEntity(block.getLocation().add(0.5, yOffset, 0.5), ChairNMS.getRegenerationAmplifier(player), !Settings.SIT_ON_ARROWS.getValueAsBoolean());
        Chair chair = new Chair(block, chairEntity, player);
        PlayerEnterChairEvent event = new PlayerEnterChairEvent(player, chair);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ChairManager.instance.chairNMS.killChairEntity(chairEntity);
            return false;
        }
        if (Settings.AUTO_ROTATE_PLAYER.getValueAsBoolean() && chair.getType() == ChairType.STAIR) {
            Location loc = player.getLocation();
            loc.setPitch(0.0f);
            switch (this.chairNMS.getBlockRotation(block)) {
                case NORTH: {
                    loc.setYaw(0.0f);
                    break;
                }
                case EAST: {
                    loc.setYaw(90.0f);
                    break;
                }
                case SOUTH: {
                    loc.setYaw(180.0f);
                    break;
                }
                case WEST: {
                    loc.setYaw(-90.0f);
                    break;
                }
            }
            player.teleport(loc);
        }
        this.chairs.add(chair);
        chairEntity.setPassenger((Entity)player);
        return true;
    }

    public void destroy(Chair chair, boolean teleportPlayer) {
        this.destroy(chair, teleportPlayer, false);
    }

    public void destroy(Chair chair, boolean teleportPlayer, boolean sameTickTeleport) {
        boolean hasPassenger;
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        boolean bl = hasPassenger = chair.chairEntity.getPassenger() != null;
        if (hasPassenger) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerLeaveChairEvent(chair.player, chair));
        }
        this.chairNMS.killChairEntity(chair.chairEntity);
        this.chairs.remove(chair);
        if (hasPassenger && teleportPlayer) {
            Runnable teleportTask = () -> chair.player.teleport(chair.getPlayerLeavingLocation());
            if (sameTickTeleport) {
                teleportTask.run();
            } else {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ChairManager.getPlugin(), teleportTask);
            }
        }
    }

    public int destroyAll(boolean teleportPlayer) {
        return this.destroyAll(teleportPlayer, false);
    }

    public int destroyAll(boolean teleportPlayer, boolean sameTickTeleport) {
        int i = 0;
        for (Chair c : this.chairs.toArray(new Chair[0])) {
            this.destroy(c, teleportPlayer, sameTickTeleport);
            ++i;
        }
        this.chairs.clear();
        return i;
    }

    public boolean isOccupied(@NotNull Block b) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        for (Chair c : this.chairs.toArray(new Chair[0])) {
            if (!b.equals((Object)c.block)) continue;
            return !c.destroyOnNoPassenger();
        }
        return false;
    }

    @Nullable
    public Chair getChair(@NotNull Player p) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        for (Chair c : this.chairs.toArray(new Chair[0])) {
            if (p != c.player || c.destroyOnNoPassenger()) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public Chair getChair(@NotNull Block b) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        for (Chair c : this.chairs.toArray(new Chair[0])) {
            if (b != c.block || c.destroyOnNoPassenger()) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public Chair getChair(@NotNull Entity entity) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Async API call");
        }
        for (Chair c : this.chairs.toArray(new Chair[0])) {
            if (entity != c.chairEntity || c.destroyOnNoPassenger()) continue;
            return c;
        }
        return null;
    }

    public boolean isChair(@NotNull Entity entity) {
        return this.getChair(entity) != null || this.chairNMS.isChair(entity);
    }

    public boolean hasChairsDisabled(OfflinePlayer player) {
        return this.hasChairsDisabled(player.getUniqueId());
    }

    public boolean hasChairsDisabled(UUID uuid) {
        Boolean value = this.disabled.get(uuid);
        if (value == null) {
            value = Settings.REMEMBER_IF_PLAYER_DISABLED_CHAIRS.getValueAsBoolean() && new File(this.disabledForDir, uuid.toString()).exists();
            if (!value.booleanValue()) {
                value = Settings.HAVE_CHAIRS_DISABLED_FOR_PLAYER_BY_DEFAULT.getValueAsBoolean();
            }
            if (Bukkit.getPlayer((UUID)uuid).isOnline()) {
                this.disabled.put(uuid, value);
            }
        }
        return value;
    }

    public void setChairsDisabled(Player player, boolean areDisabled) {
        this.setChairsDisabled(player.getUniqueId(), areDisabled);
    }

    public void setChairsDisabled(UUID uuid, boolean areDisabled) {
        boolean directlyWriteToFile;
        boolean isOnline = Bukkit.getOfflinePlayer((UUID)uuid).isOnline();
        boolean bl = directlyWriteToFile = !isOnline && Settings.REMEMBER_IF_PLAYER_DISABLED_CHAIRS.getValueAsBoolean();
        if (isOnline || directlyWriteToFile) {
            this.disabled.put(uuid, areDisabled);
        }
        if (directlyWriteToFile) {
            this.onQuit(uuid);
        }
    }

    @NotNull
    public static Logger getLogger() {
        return plugin != null ? plugin.getLogger() : Logger.getGlobal();
    }

    @Nullable
    public static ChairManager getInstance() {
        return instance;
    }

    @Nullable
    public static JavaPlugin getPlugin() {
        return plugin;
    }
}

