/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs;

import de.sprax2013.betterchairs.BetterChairsPlugin;
import de.sprax2013.betterchairs.Chair;
import de.sprax2013.betterchairs.ChairManager;
import de.sprax2013.betterchairs.Messages;
import de.sprax2013.betterchairs.Settings;
import de.sprax2013.betterchairs.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;

public class EventListener
implements Listener {
    private static final List<XMaterial> WALL_SIGN_MATERIALS = Arrays.asList(XMaterial.ACACIA_WALL_SIGN, XMaterial.BAMBOO_WALL_SIGN, XMaterial.BIRCH_WALL_SIGN, XMaterial.CHERRY_WALL_SIGN, XMaterial.CRIMSON_WALL_SIGN, XMaterial.DARK_OAK_WALL_SIGN, XMaterial.JUNGLE_WALL_SIGN, XMaterial.MANGROVE_WALL_SIGN, XMaterial.OAK_WALL_SIGN, XMaterial.SPRUCE_WALL_SIGN, XMaterial.WARPED_WALL_SIGN);
    private List<Material> filteredMaterials;

    public EventListener() {
        Runnable task = () -> {
            if (Settings.MATERIAL_FILTER_ENABLED.getValueAsBoolean()) {
                this.getMaterialFilter();
            }
        };
        Settings.getConfig().addListener(() -> {
            this.filteredMaterials = null;
            task.run();
        });
        task.run();
    }

    private List<Material> getMaterialFilter() {
        if (this.filteredMaterials == null) {
            this.filteredMaterials = new ArrayList<Material>();
            List<String> names = Settings.MATERIAL_FILTER_NAMES.getValueAsStringList();
            if (names != null) {
                for (String name : names) {
                    Optional<XMaterial> xMat = XMaterial.matchXMaterial(name);
                    Material mat = null;
                    if (xMat.isPresent()) {
                        mat = xMat.get().parseMaterial();
                    }
                    if (mat != null) {
                        this.filteredMaterials.add(mat);
                        continue;
                    }
                    ChairManager.getLogger().warning(() -> "Invalid block type '" + name + "' in " + Settings.MATERIAL_FILTER_NAMES.getKey());
                }
            }
        }
        return this.filteredMaterials;
    }

    @EventHandler(priority=EventPriority.HIGH)
    private void onInteract(PlayerInteractEvent e) {
        boolean blockInFilter;
        boolean worldInFilter;
        if (e.isCancelled() && !Settings.IGNORES_INTERACT_PREVENTION.getValueAsBoolean()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Chair chairTheCurrentPlayerIsSittingIn = BetterChairsPlugin.getManager().getChair(e.getPlayer());
        if (!e.getClickedBlock().getWorld().equals((Object)e.getPlayer().getLocation().getWorld())) {
            return;
        }
        if (e.getPlayer().isSneaking()) {
            return;
        }
        if (BetterChairsPlugin.getManager().hasChairsDisabled((OfflinePlayer)e.getPlayer())) {
            return;
        }
        if (chairTheCurrentPlayerIsSittingIn != null && !Settings.ALLOW_SWITCHING_SEATS.getValueAsBoolean()) {
            return;
        }
        if (e.getPlayer().getVehicle() != null && !Settings.ALLOW_SWITCHING_SEATS.getValueAsBoolean()) {
            return;
        }
        if (!e.getPlayer().hasPermission(BetterChairsPlugin.getInstance().getName() + ".use")) {
            return;
        }
        if (Settings.NEEDS_EMPTY_HANDS.getValueAsBoolean() && !BetterChairsPlugin.getManager().chairNMS.hasEmptyMainHand(e.getPlayer())) {
            return;
        }
        if (Settings.WORLD_FILTER_ENABLED.getValueAsBoolean() && (worldInFilter = Objects.requireNonNull(Settings.WORLD_FILTER_NAMES.getValueAsStringList()).contains(e.getPlayer().getWorld().getName())) == Settings.WORLD_FILTER_AS_BLACKLIST.getValueAsBoolean()) {
            return;
        }
        if (!(Settings.MATERIAL_FILTER_ENABLED.getValueAsBoolean() && Settings.MATERIAL_FILTER_ALLOW_ALL_TYPES.getValueAsBoolean() || BetterChairsPlugin.getManager().chairNMS.isStair(e.getClickedBlock()) || BetterChairsPlugin.getManager().chairNMS.isSlab(e.getClickedBlock()))) {
            return;
        }
        if (!e.getClickedBlock().getRelative(BlockFace.UP).isEmpty() && Settings.CHAIR_NEED_AIR_ABOVE.getValueAsBoolean()) {
            return;
        }
        if (e.getClickedBlock().getRelative(BlockFace.DOWN).isEmpty() && !Settings.CHAIR_ALLOW_AIR_BELOW.getValueAsBoolean()) {
            return;
        }
        if (!Settings.MATERIAL_FILTER_ENABLED.getValueAsBoolean() || Settings.MATERIAL_FILTER_ENABLED.getValueAsBoolean() && !Settings.MATERIAL_FILTER_ALLOW_ALL_TYPES.getValueAsBoolean()) {
            if (!Settings.USE_STAIRS.getValueAsBoolean() && BetterChairsPlugin.getManager().chairNMS.isStair(e.getClickedBlock()) || !Settings.USE_SLABS.getValueAsBoolean() && BetterChairsPlugin.getManager().chairNMS.isSlab(e.getClickedBlock())) {
                return;
            }
            if (BetterChairsPlugin.getManager().chairNMS.isStair(e.getClickedBlock()) && BetterChairsPlugin.getManager().chairNMS.isStairUpsideDown(e.getClickedBlock())) {
                return;
            }
        }
        if (Settings.MATERIAL_FILTER_ENABLED.getValueAsBoolean() && (blockInFilter = this.getMaterialFilter().contains(e.getClickedBlock().getType())) == Settings.MATERIAL_FILTER_AS_BLACKLIST.getValueAsBoolean()) {
            return;
        }
        if (BetterChairsPlugin.getManager().isOccupied(e.getClickedBlock())) {
            if (Settings.MSG_ALREADY_OCCUPIED.getValueAsBoolean() && (chairTheCurrentPlayerIsSittingIn == null || !chairTheCurrentPlayerIsSittingIn.getBlock().equals((Object)e.getClickedBlock()))) {
                e.getPlayer().sendMessage(Messages.getString(Messages.USE_ALREADY_OCCUPIED));
            }
            return;
        }
        if (Settings.NEEDS_SIGNS.getValueAsBoolean()) {
            boolean signOption2;
            BlockFace rotation = BetterChairsPlugin.getManager().chairNMS.getBlockRotation(e.getClickedBlock());
            BlockFace side1 = rotation == BlockFace.NORTH || rotation == BlockFace.SOUTH ? BlockFace.WEST : BlockFace.NORTH;
            BlockFace side2 = rotation == BlockFace.NORTH || rotation == BlockFace.SOUTH ? BlockFace.EAST : BlockFace.SOUTH;
            Block block1 = e.getClickedBlock().getRelative(side1);
            Block block2 = e.getClickedBlock().getRelative(side2);
            if (!WALL_SIGN_MATERIALS.contains(XMaterial.matchXMaterial(block1.getType())) || !WALL_SIGN_MATERIALS.contains(XMaterial.matchXMaterial(block2.getType()))) {
                if (Settings.MSG_NEEDS_SIGNS.getValueAsBoolean()) {
                    e.getPlayer().sendMessage(Messages.getString(Messages.USE_NEEDS_SIGNS));
                }
                return;
            }
            boolean signOption1 = side1 != BetterChairsPlugin.getManager().chairNMS.getBlockRotation(block1).getOppositeFace() || side2 != BetterChairsPlugin.getManager().chairNMS.getBlockRotation(block2).getOppositeFace();
            boolean bl = signOption2 = side2 != BetterChairsPlugin.getManager().chairNMS.getBlockRotation(block1).getOppositeFace() || side1 != BetterChairsPlugin.getManager().chairNMS.getBlockRotation(block2).getOppositeFace();
            if (!signOption1 && !signOption2) {
                if (Settings.MSG_NEEDS_SIGNS.getValueAsBoolean()) {
                    e.getPlayer().sendMessage(Messages.getString(Messages.USE_NEEDS_SIGNS));
                }
                return;
            }
        }
        if (Settings.ALLOWED_DISTANCE_TO_CHAIR.getValueAsInt() > 0) {
            Location location = e.getPlayer().getLocation();
            Location location2 = e.getClickedBlock().getLocation();
            double d = e.getClickedBlock().getX() > 0 ? 0.5 : -0.5;
            double d2 = e.getClickedBlock().getZ() > 0 ? 0.5 : -0.5;
            if (location.distance(location2.add(d, 0.0, d2)) > (double)Settings.ALLOWED_DISTANCE_TO_CHAIR.getValueAsInt()) {
                return;
            }
        }
        boolean createChairOnNextTick = false;
        Chair currentChair = BetterChairsPlugin.getManager().getChair(e.getPlayer());
        if (currentChair != null) {
            createChairOnNextTick = true;
            BetterChairsPlugin.getManager().destroy(currentChair, true, true);
        }
        Runnable createChairTask = () -> {
            if (BetterChairsPlugin.getManager().create(e.getPlayer(), e.getClickedBlock())) {
                e.setCancelled(true);
                if (Settings.MSG_NOW_SITTING.getValueAsBoolean()) {
                    e.getPlayer().sendMessage(Messages.getString(Messages.USE_NOW_SITTING));
                }
            }
        };
        if (createChairOnNextTick) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BetterChairsPlugin.getInstance(), createChairTask);
        } else {
            createChairTask.run();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onDismount(EntityDismountEvent e) {
        Chair c = BetterChairsPlugin.getManager().getChair(e.getDismounted());
        if (c != null) {
            BetterChairsPlugin.getManager().destroy(c, true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onQuit(PlayerQuitEvent e) {
        Entity vehicle = e.getPlayer().getVehicle();
        Chair c = BetterChairsPlugin.getManager().getChair(vehicle);
        if (c != null) {
            BetterChairsPlugin.getManager().destroy(c, true, true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onQuitMonitor(PlayerQuitEvent e) {
        BetterChairsPlugin.getManager().onQuit(e.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(EntitySpawnEvent e) {
        if (!e.isCancelled()) {
            return;
        }
        if (BetterChairsPlugin.getManager().isChair(e.getEntity())) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onTeleport(EntityTeleportEvent e) {
        if (BetterChairsPlugin.getManager().isChair(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onTeleportMonitor(EntityTeleportEvent e) {
        Chair chair = BetterChairsPlugin.getManager().getChair(e.getEntity());
        if (chair != null) {
            BetterChairsPlugin.getManager().destroy(chair, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onBlockBreak(BlockBreakEvent e) {
        if (BetterChairsPlugin.getManager().isOccupied(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onBlockBreakMonitor(BlockBreakEvent e) {
        Chair chair = BetterChairsPlugin.getManager().getChair(e.getBlock());
        if (chair != null) {
            BetterChairsPlugin.getManager().destroy(chair, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onPistonExtend(BlockPistonExtendEvent e) {
        for (Block b : e.getBlocks()) {
            if (!BetterChairsPlugin.getManager().isOccupied(b)) continue;
            e.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPistonExtendMonitor(BlockPistonExtendEvent e) {
        for (Block b : e.getBlocks()) {
            Chair chair = BetterChairsPlugin.getManager().getChair(b);
            if (chair == null) continue;
            BetterChairsPlugin.getManager().destroy(chair, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onPistonRetract(BlockPistonRetractEvent e) {
        for (Block b : e.getBlocks()) {
            if (!BetterChairsPlugin.getManager().isOccupied(b)) continue;
            e.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPistonRetractMonitor(BlockPistonRetractEvent e) {
        for (Block b : e.getBlocks()) {
            Chair chair = BetterChairsPlugin.getManager().getChair(b);
            if (chair == null) continue;
            BetterChairsPlugin.getManager().destroy(chair, true);
        }
    }
}

