/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration;

import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.LimeDevUtility;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigCommentProvider;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigEntry;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigListener;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigSerializable;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigVersionEntry;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.LegacyConfigKey;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.validation.EntryValidator;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.DumperOptions;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.LoaderOptions;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.Yaml;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.constructor.BaseConstructor;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.constructor.Constructor;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final String ERR_NO_FILE = "You have to set a file for the configuration";
    private static Yaml yaml;
    @Nullable
    private ConfigVersionEntry cfgVersionEntry;
    private final Map<@NotNull String, @NotNull ConfigEntry> entries = new LinkedHashMap<String, ConfigEntry>();
    private final Map<@NotNull String, @NotNull ConfigEntry> commentEntries = new LinkedHashMap<String, ConfigEntry>();
    private final List<ConfigListener> cfgListeners = new ArrayList<ConfigListener>();
    @Nullable
    private File file;
    @Nullable
    private ConfigCommentProvider commentProvider;

    public Config() {
        this((File)null);
    }

    public Config(@Nullable File file) {
        this(file, (ConfigCommentProvider)null);
    }

    public Config(@Nullable File file, @Nullable String comment) {
        this(file, () -> comment);
    }

    public Config(@Nullable File file, @Nullable ConfigCommentProvider commentProvider) {
        this.file = file;
        this.commentProvider = commentProvider;
    }

    public Config(@NotNull Config baseCfg) {
        this(baseCfg.file, baseCfg.commentProvider);
        if (baseCfg.cfgVersionEntry != null) {
            Object firstVersion = baseCfg.cfgVersionEntry.getDefaultValue();
            if (firstVersion instanceof Number) {
                this.withVersion(baseCfg.cfgVersionEntry.getTargetVersion(), (Integer)firstVersion, baseCfg.cfgVersionEntry.getKey(), baseCfg.getCommentProvider());
            } else {
                this.withVersion(baseCfg.cfgVersionEntry.getTargetVersion(), baseCfg.cfgVersionEntry.getKey(), baseCfg.getCommentProvider());
            }
        }
        for (ConfigEntry entry : baseCfg.entries.values()) {
            this.withEntry(entry.getKey(), entry.getDefaultValue(), entry.getCommentProvider());
        }
        for (ConfigEntry entry : baseCfg.commentEntries.values()) {
            ConfigCommentProvider commentP = entry.getCommentProvider();
            if (commentP == null) {
                commentP = () -> "";
            }
            this.withCommentEntry(entry.getKey(), commentP);
        }
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    public void setFile(@Nullable File file) {
        this.file = file;
    }

    public Config setCommentProvider(@Nullable ConfigCommentProvider commentProvider) {
        this.commentProvider = commentProvider;
        return this;
    }

    @Nullable
    public ConfigCommentProvider getCommentProvider() {
        return this.commentProvider;
    }

    @Nullable
    public String getFormattedComment() {
        String comment;
        String string = comment = this.commentProvider != null ? this.commentProvider.getComment() : null;
        if (comment != null && !comment.isEmpty()) {
            return "# " + comment.replace("\n", "\n# ") + "\n\n";
        }
        return null;
    }

    @Nullable
    public ConfigVersionEntry getVersionEntry() {
        return this.cfgVersionEntry;
    }

    @NotNull
    public Config withVersion(int cfgVersion) {
        return this.withVersion(cfgVersion, "version");
    }

    @NotNull
    public Config withVersion(int cfgVersion, @NotNull String key) {
        return this.withVersion(cfgVersion, key, "This version is for internal use only");
    }

    @NotNull
    public Config withVersion(int cfgVersion, @NotNull String key, @Nullable String comment) {
        return this.withVersion(cfgVersion, key, comment != null ? () -> comment : null);
    }

    @NotNull
    public Config withVersion(int cfgVersion, @NotNull String key, @Nullable ConfigCommentProvider commentProvider) {
        return this.withVersion(cfgVersion, 1, key, commentProvider);
    }

    @NotNull
    public Config withVersion(int cfgVersion, int firstVersion, @NotNull String key, @Nullable ConfigCommentProvider commentProvider) {
        ConfigVersionEntry verEntry = new ConfigVersionEntry(key, cfgVersion, firstVersion, commentProvider);
        if (this.getEntry(key) != null) {
            throw new IllegalStateException("Version entry key is already being used");
        }
        this.cfgVersionEntry = verEntry;
        return this;
    }

    @NotNull
    public Config withEntry(@NotNull String key, @Nullable Object defaultValue) {
        this.createEntry(key, defaultValue);
        return this;
    }

    @NotNull
    public Config withEntry(@NotNull String key, @Nullable Object defaultValue, @Nullable String comment) {
        this.createEntry(key, defaultValue, comment);
        return this;
    }

    @NotNull
    public Config withEntry(@NotNull String key, @Nullable Object defaultValue, @Nullable ConfigCommentProvider commentProvider) {
        this.createEntry(key, defaultValue, commentProvider);
        return this;
    }

    @NotNull
    public ConfigEntry createEntry(@NotNull String key, @Nullable Object defaultValue) {
        return this.createEntry(key, defaultValue, (ConfigCommentProvider)null);
    }

    @NotNull
    public ConfigEntry createEntry(@NotNull String key, @Nullable Object defaultValue, @Nullable String comment) {
        return this.createEntry(key, defaultValue, comment != null ? () -> comment : null);
    }

    @NotNull
    public ConfigEntry createEntry(@NotNull String key, @Nullable Object defaultValue, @Nullable ConfigCommentProvider commentProvider) {
        if (this.entries.containsKey(key)) {
            throw new IllegalArgumentException("Entry with the key '" + key + "' already exists on this config");
        }
        if (this.cfgVersionEntry != null && this.cfgVersionEntry.getKey().equals(key)) {
            throw new IllegalArgumentException("Entry with the key '" + key + "' is already used by the version entry");
        }
        ConfigEntry cfgEntry = new ConfigEntry(key, defaultValue, commentProvider);
        this.entries.put(key, cfgEntry);
        return cfgEntry;
    }

    @NotNull
    public Config withCommentEntry(@NotNull String key, @NotNull String comment) {
        this.addCommentEntry(key, comment);
        return this;
    }

    @NotNull
    public Config withCommentEntry(@NotNull String key, @NotNull ConfigCommentProvider commentProvider) {
        this.addCommentEntry(key, commentProvider);
        return this;
    }

    @NotNull
    public ConfigEntry addCommentEntry(@NotNull String key, @NotNull String comment) {
        return this.addCommentEntry(key, () -> comment);
    }

    @NotNull
    public ConfigEntry addCommentEntry(@NotNull String key, @NotNull ConfigCommentProvider commentProvider) {
        if (this.commentEntries.containsKey(key)) {
            throw new IllegalArgumentException("CommentEntry with the key '" + key + "' already exists on this config");
        }
        ConfigEntry cfgEntry = new ConfigEntry(key, null, commentProvider);
        this.commentEntries.put(key, cfgEntry);
        return cfgEntry;
    }

    @Nullable
    public ConfigEntry getEntry(@NotNull String key) {
        return this.entries.get(key);
    }

    @Nullable
    public ConfigEntry getCommentEntry(@NotNull String key) {
        return this.commentEntries.get(key);
    }

    public boolean removeEntry(@NotNull String key) {
        return this.entries.remove(key) != null;
    }

    public boolean removeCommentEntry(@NotNull String key) {
        return this.commentEntries.remove(key) != null;
    }

    public boolean load() {
        return this.load(true);
    }

    public boolean load(boolean performCfgUpgrade) {
        try {
            this.loadWithException(performCfgUpgrade);
            return true;
        }
        catch (IOException ex) {
            LimeDevUtility.LOGGER.throwing(this.getClass().getName(), "load", ex);
            LimeDevUtility.LOGGER.log(Level.SEVERE, "Failed to load config file" + (this.file != null ? " '" + this.file.getName() + "'" : ""), ex);
            return false;
        }
    }

    public void loadWithException() throws IOException {
        this.loadWithException(true);
    }

    public void loadWithException(boolean performCfgUpgrade) throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException(ERR_NO_FILE);
        }
        this.reset();
        if (this.file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
                Object value;
                Object yamlData = Config.getSnakeYaml().load(reader);
                if (!(yamlData instanceof Map)) {
                    throw new IllegalStateException("The YAML file does not have the expected tree structure");
                }
                if (this.cfgVersionEntry != null && (value = this.retrieveValueFromMapStructure((Map)yamlData, this.cfgVersionEntry.getKey())) != null) {
                    EntryValidator validator = this.cfgVersionEntry.getEntryValidator();
                    if (validator != null && !validator.isValid(value)) {
                        LimeDevUtility.LOGGER.warning(() -> "Invalid value(=" + value + ") inside " + this.file.getName() + " for '" + this.cfgVersionEntry.getKey() + "' (default value: '" + this.cfgVersionEntry.getDefaultValue() + "')");
                    }
                    this.cfgVersionEntry.setValue(value);
                }
                if (performCfgUpgrade && this.cfgVersionEntry != null) {
                    boolean createdBackup = false;
                    while (this.cfgVersionEntry.requiresUpgrade()) {
                        for (ConfigEntry entry : this.entries.values()) {
                            LegacyConfigKey legacyKey = entry.getLegacyKey(this.cfgVersionEntry.getCurrentVersion());
                            if (legacyKey == null) continue;
                            Object legacyValue = this.retrieveValueFromMapStructure((Map)yamlData, legacyKey.getKey() != null ? legacyKey.getKey() : entry.getKey());
                            if (legacyKey.getKey() == null) {
                                if (legacyKey.getKeyUpgrader() == null) continue;
                                if (!createdBackup) {
                                    this.backupFile();
                                    createdBackup = true;
                                }
                                entry.setValue(legacyKey.getKeyUpgrader().accept(legacyValue));
                                continue;
                            }
                            if (legacyValue == null || this.retrieveValueFromMapStructure((Map)yamlData, entry.getKey()) != null) continue;
                            if (legacyKey.getKeyUpgrader() != null) {
                                if (!createdBackup) {
                                    this.backupFile();
                                    createdBackup = true;
                                }
                                entry.setValue(legacyKey.getKeyUpgrader().accept(legacyValue));
                                continue;
                            }
                            if (!createdBackup) {
                                this.backupFile();
                                createdBackup = true;
                            }
                            entry.setValue(legacyValue);
                        }
                        this.cfgVersionEntry.incrementVersion();
                    }
                }
                for (ConfigEntry cfgEntry : this.entries.values()) {
                    Object value2 = this.retrieveValueFromMapStructure((Map)yamlData, cfgEntry.getKey());
                    if (value2 == null) continue;
                    EntryValidator validator = cfgEntry.getEntryValidator();
                    if (validator != null && !validator.isValid(value2)) {
                        LimeDevUtility.LOGGER.warning(() -> "Invalid value(=" + value2 + ") inside " + this.file.getName() + " for '" + cfgEntry.getKey() + "' (default value: '" + cfgEntry.getDefaultValue() + "')");
                    }
                    cfgEntry.setValue(value2);
                }
            }
        }
        this.cfgListeners.forEach(ConfigListener::onLoad);
    }

    public boolean save() {
        try {
            this.saveWithException();
            return true;
        }
        catch (IOException ex) {
            LimeDevUtility.LOGGER.throwing(this.getClass().getName(), "save", ex);
            LimeDevUtility.LOGGER.log(Level.SEVERE, "Failed to save config file" + (this.file != null ? " '" + this.file.getName() + "'" : ""), ex);
            return false;
        }
    }

    public void saveWithException() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException(ERR_NO_FILE);
        }
        String yamlStr = this.toString();
        if (!this.file.getParentFile().exists()) {
            Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append(yamlStr);
        }
    }

    public void backupFile() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException(ERR_NO_FILE);
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException("File '" + this.file.getAbsolutePath() + "' does not exist");
        }
        Files.copy(this.file.toPath(), new File(this.file.getParentFile(), "backup-" + Config.getFileBaseName(this.file.getName()) + "-" + System.currentTimeMillis() + "." + Config.getFileExtension(this.file.getName())).toPath(), StandardCopyOption.COPY_ATTRIBUTES);
    }

    @NotNull
    public Config addListener(@NotNull ConfigListener listener) {
        if (!this.cfgListeners.contains(listener)) {
            this.cfgListeners.add(listener);
        }
        return this;
    }

    @NotNull
    public Config clearListeners() {
        this.cfgListeners.clear();
        return this;
    }

    @NotNull
    public Config reset() {
        for (ConfigEntry cfgEntry : this.entries.values()) {
            cfgEntry.setValue(cfgEntry.getDefaultValue());
        }
        return this;
    }

    @NotNull
    public String toString() {
        LinkedHashMap<Object, Object> dataRoot = new LinkedHashMap<Object, Object>();
        LinkedList<ConfigEntry> cfgEntries = new LinkedList<ConfigEntry>(this.entries.values());
        if (this.cfgVersionEntry != null) {
            cfgEntries.add(0, this.cfgVersionEntry);
        }
        for (ConfigEntry cfgEntry : cfgEntries) {
            if (cfgEntry.getValue() == null) continue;
            String[] nodeTree = cfgEntry.getKey().split("\\.");
            Map nodeMap = dataRoot;
            for (int i = 0; i < nodeTree.length - 1; ++i) {
                Object node = nodeTree[i];
                Object innerNodeMap = nodeMap.get(node);
                if (!(innerNodeMap instanceof Map)) {
                    if (innerNodeMap != null) {
                        throw new IllegalStateException("The ConfigEntry '" + cfgEntry.getKey() + "' conflicts with another entry");
                    }
                    innerNodeMap = new LinkedHashMap();
                    nodeMap.put(node, innerNodeMap);
                }
                nodeMap = (Map)innerNodeMap;
            }
            nodeMap.put(nodeTree[nodeTree.length - 1], Config.serializeObject(cfgEntry.getValue()));
        }
        String yamlStr = Config.getSnakeYaml().dump(dataRoot);
        LinkedList<ConfigEntry> entryList = new LinkedList<ConfigEntry>();
        entryList.addAll(cfgEntries);
        entryList.addAll(this.commentEntries.values());
        for (ConfigEntry cfgEntry : entryList) {
            String comment = cfgEntry.getFormattedComment();
            if (comment == null) continue;
            Map<Object, Object> nodeMap = dataRoot;
            String[] nodeTree = cfgEntry.getKey().split("\\.");
            for (int i = 0; i < nodeTree.length - 1; ++i) {
                String node = nodeTree[i];
                Object innerNodeValue = nodeMap.get(node);
                if (innerNodeValue == null) {
                    nodeMap = null;
                    break;
                }
                nodeMap = (Map)innerNodeValue;
            }
            if (nodeMap == null || !nodeMap.containsKey(nodeTree[nodeTree.length - 1])) continue;
            yamlStr = this.injectComment(yamlStr, cfgEntry.getKey(), comment);
        }
        String comment = this.getFormattedComment();
        if (comment != null) {
            return comment + yamlStr;
        }
        return yamlStr;
    }

    private Object retrieveValueFromMapStructure(@NotNull Map<?, ?> yamlData, @NotNull String key) {
        String[] nodeTree = key.split("\\.");
        Map<Object, Object> obj = yamlData;
        for (int i = 0; i < nodeTree.length - 1; ++i) {
            String node = nodeTree[i];
            if ((obj = obj.get(node)) instanceof Map) continue;
            obj = null;
            break;
        }
        if (obj != null) {
            return obj.get(nodeTree[nodeTree.length - 1]);
        }
        return null;
    }

    @NotNull
    private String injectComment(String yaml, String key, String comment) {
        String[] nodes = key.split("\\.");
        int index = -1;
        for (int depth = 0; depth < nodes.length && (depth <= 0 || index != -1); ++depth) {
            index = yaml.indexOf(Config.repeatString("  ", depth) + nodes[depth], index + 1);
        }
        if (index == -1) {
            throw new IllegalArgumentException("The given key(=" + key + ") does not exist!");
        }
        return yaml.substring(0, index) + ("\n" + comment).replace("\n", "\n" + Config.repeatString("  ", nodes.length - 1)) + "\n" + yaml.substring(index);
    }

    @NotNull
    private static Yaml getSnakeYaml() {
        if (yaml == null) {
            LoaderOptions yamlOptions = new LoaderOptions();
            yamlOptions.setAllowDuplicateKeys(false);
            yamlOptions.setWrappedToRootException(true);
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            yaml = new Yaml((BaseConstructor)new Constructor(yamlOptions), new Representer(), dumperOptions, yamlOptions);
        }
        return yaml;
    }

    @Nullable
    private static Object serializeObject(Object obj) {
        if (obj instanceof ConfigSerializable) {
            return ((ConfigSerializable)obj).serializeToMap();
        }
        if (obj.getClass().isEnum()) {
            return ((Enum)obj).name();
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>(((List)obj).size());
            boolean containsMap = false;
            for (Object ele : (List)obj) {
                Object serializedEle = Config.serializeObject(ele);
                boolean doneSerializing = false;
                while (!doneSerializing) {
                    Object newEle = Config.serializeObject(serializedEle);
                    doneSerializing = Objects.equals(newEle, serializedEle);
                    serializedEle = newEle;
                }
                if (serializedEle instanceof Map) {
                    containsMap = true;
                }
                newList.add(serializedEle);
            }
            if (containsMap) {
                LinkedHashMap newMap = new LinkedHashMap(newList.size());
                for (int i = 0; i < newList.size(); ++i) {
                    newMap.put(i, newList.get(i));
                }
                return newMap;
            }
            return newList;
        }
        if (obj instanceof Map) {
            LinkedHashMap newMap = new LinkedHashMap(((Map)obj).size());
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                Object serializedValue = Config.serializeObject(entry.getValue());
                boolean doneSerializing = false;
                while (!doneSerializing) {
                    Object newValue = Config.serializeObject(serializedValue);
                    doneSerializing = Objects.equals(newValue, serializedValue);
                    serializedValue = newValue;
                }
                newMap.put(entry.getKey(), serializedValue);
            }
            return newMap;
        }
        return obj;
    }

    @NotNull
    private static String repeatString(String str, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (count == 0 || str.isEmpty()) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    @NotNull
    private static String getFileBaseName(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    @NotNull
    private static String getFileExtension(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        return index == -1 ? "" : fileName.substring(index + 1);
    }
}

