/*
 * Decompiled with CFR 0.152.
 */
package de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration;

import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.ConfigCommentProvider;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.LegacyConfigKey;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.legacy.LegacyKeyUpgrader;
import de.sprax2013.betterchairs.third_party.de.sprax2013.lime.configuration.validation.EntryValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry {
    @NotNull
    private final String key;
    @Nullable
    private final Object defaultValue;
    @Nullable
    private EntryValidator entryValidator;
    @Nullable
    private ConfigCommentProvider commentProvider;
    @Nullable
    private Map<Integer, LegacyConfigKey> legacyKeys;
    private Object value;

    protected ConfigEntry(@NotNull String key, @Nullable Object defaultValue) {
        this(key, defaultValue, null);
    }

    protected ConfigEntry(@NotNull String key, @Nullable Object defaultValue, @Nullable ConfigCommentProvider commentProvider) {
        this.key = Objects.requireNonNull(key);
        this.defaultValue = defaultValue;
        this.commentProvider = commentProvider;
        this.value = defaultValue;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public ConfigEntry setEntryValidator(@Nullable EntryValidator entryValidator) {
        if (entryValidator != null && !entryValidator.isValid(this.defaultValue)) {
            throw new IllegalArgumentException("The EntryValidator returns false for the Entry's default value");
        }
        this.entryValidator = entryValidator;
        return this;
    }

    @Nullable
    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }

    @NotNull
    public ConfigEntry setCommentProvider(@Nullable ConfigCommentProvider commentProvider) {
        this.commentProvider = commentProvider;
        return this;
    }

    @Nullable
    public ConfigCommentProvider getCommentProvider() {
        return this.commentProvider;
    }

    @Nullable
    public String getFormattedComment() {
        String comment;
        String string = comment = this.commentProvider != null ? this.commentProvider.getComment() : null;
        if (comment != null && !comment.isEmpty()) {
            return "# " + comment.replaceAll("\n", "\n# ");
        }
        return null;
    }

    @NotNull
    public ConfigEntry setLegacyKey(int cfgVersion, @Nullable String legacyKey) {
        return this.setLegacyKey(cfgVersion, legacyKey, null);
    }

    @NotNull
    public ConfigEntry setLegacyKey(int cfgVersion, @Nullable String legacyKey, @Nullable LegacyKeyUpgrader keyUpgrader) {
        if (this.legacyKeys == null) {
            this.legacyKeys = new HashMap<Integer, LegacyConfigKey>(1, 1.0f);
        }
        this.legacyKeys.put(cfgVersion, new LegacyConfigKey(legacyKey, keyUpgrader));
        return this;
    }

    @Nullable
    public LegacyConfigKey getLegacyKey(int cfgVersionAtThatTime) {
        return this.legacyKeys != null ? this.legacyKeys.get(cfgVersionAtThatTime) : null;
    }

    @NotNull
    public ConfigEntry setValue(@Nullable Object value) {
        this.value = value instanceof Object[] ? Arrays.asList((Object[])value) : value;
        return this;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public <T> T getValue(T type) {
        return (T)this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public <T extends Enum<T>> T getValueAsEnum(Class<T> enumType) {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        if (result instanceof String) {
            return Enum.valueOf(enumType, (String)result);
        }
        if (enumType.isInstance(result)) {
            return (T)((Enum)enumType.cast(result));
        }
        return null;
    }

    public boolean getValueAsBoolean() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        return result instanceof Boolean ? (Boolean)result : Boolean.parseBoolean((String)result);
    }

    public int getValueAsInt() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        if (result == null) {
            return 0;
        }
        return result instanceof Number ? ((Number)result).intValue() : Integer.parseInt((String)result);
    }

    public long getValueAsLong() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        if (result == null) {
            return 0L;
        }
        return result instanceof Number ? ((Number)result).longValue() : Long.parseLong((String)result);
    }

    public float getValueAsFloat() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        if (result == null) {
            return 0.0f;
        }
        return result instanceof Number ? ((Number)result).floatValue() : Float.parseFloat((String)result);
    }

    public double getValueAsDouble() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        if (result == null) {
            return 0.0;
        }
        return result instanceof Number ? ((Number)result).doubleValue() : Double.parseDouble((String)result);
    }

    @Nullable
    public String getValueAsString() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        return result == null ? null : result.toString();
    }

    @Nullable
    public List<Object> getValueAsList() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        return (List)result;
    }

    @Nullable
    public List<String> getValueAsStringList() {
        Object result = this.entryValidator == null || this.entryValidator.isValid(this.value) ? this.value : this.defaultValue;
        return (List)result;
    }
}

