/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.expensivedeaths;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import net.silverstonemc.expensivedeaths.Execution;
import net.silverstonemc.expensivedeaths.ExpensiveDeaths;
import org.apache.commons.lang.LocaleUtils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathEvent
implements Listener {
    private final Economy econ = ExpensiveDeaths.getInstance().getEconomy();
    private final Permission perms = ExpensiveDeaths.getInstance().getPermissions();
    private final ExpensiveDeaths plugin;

    public DeathEvent(ExpensiveDeaths plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void deathEvent(PlayerDeathEvent event) {
        EconomyResponse result;
        Player player = event.getEntity();
        if (player.hasPermission("expensivedeaths.bypass")) {
            if (!this.plugin.getConfig().getString("bypass-message").isBlank()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("bypass-message")));
            }
            return;
        }
        String primaryGroup = this.perms.getPrimaryGroup(null, (OfflinePlayer)player).toLowerCase();
        if (!this.plugin.getConfig().contains("amount-to-take." + primaryGroup)) {
            primaryGroup = "default";
        }
        String option = this.plugin.getConfig().getString("amount-to-take." + primaryGroup);
        DecimalFormat format = new DecimalFormat(this.plugin.getConfig().getString("currency-format"));
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(LocaleUtils.toLocale((String)("en_" + this.plugin.getConfig().getString("currency-country")))));
        if (option.equalsIgnoreCase("ALL")) {
            result = this.econ.withdrawPlayer((OfflinePlayer)player, this.econ.getBalance((OfflinePlayer)player));
        } else if (option.contains("%")) {
            if (option.contains("-")) {
                double min = Double.parseDouble(option.replaceAll("-.*", ""));
                double max = Double.parseDouble(option.replaceAll(".*-", "").replace("%", ""));
                double r = ThreadLocalRandom.current().nextDouble(min, max + 1.0);
                result = this.econ.withdrawPlayer((OfflinePlayer)player, r / 100.0 * this.econ.getBalance((OfflinePlayer)player));
            } else {
                result = this.econ.withdrawPlayer((OfflinePlayer)player, Double.parseDouble(option.replace("%", "")) / 100.0 * this.econ.getBalance((OfflinePlayer)player));
            }
        } else {
            result = this.econ.withdrawPlayer((OfflinePlayer)player, Double.parseDouble(option));
        }
        String money = String.valueOf(format.format(result.amount));
        String balance = String.valueOf(format.format(result.balance));
        if (!this.plugin.getConfig().getString("death-message").isBlank() && !money.equals("0.00")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("death-message").replace("{MONEY}", money).replace("{BALANCE}", balance)));
        }
        Player killer = player.getKiller();
        Function<String, String> parser = str -> {
            String s = str.replace("{PLAYER}", player.getName()).replace("{DISPLAYNAME}", player.getDisplayName()).replace("{MONEY}", money).replace("{BALANCE}", balance);
            if (killer != null) {
                s = s.replace("{KILLER}", killer.getName()).replace("{KILLER_DISPLAYNAME}", killer.getDisplayName());
            }
            return s;
        };
        this.plugin.run(Execution.Type.DEATH_CONSOLE, player, killer, parser);
        this.plugin.run(Execution.Type.DEATH_PLAYER, player, killer, parser);
        if (killer != null) {
            this.plugin.run(Execution.Type.KILL_CONSOLE, player, killer, parser);
            this.plugin.run(Execution.Type.KILL_PLAYER, player, killer, parser);
        }
    }
}

