/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.expensivedeaths;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.silverstonemc.expensivedeaths.ExpensiveDeaths;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class Execution {
    private static final Supplier<Boolean> USE_PLACEHOLDERAPI = Suppliers.memoize(() -> Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI"));
    private static final Pattern KEY_CHANCE = Pattern.compile("(?i)(test-?)?(chance|prob(ability)?)");
    private static final Pattern KEY_CANCEL = Pattern.compile("(?i)break|stop|cancel(ling)?");
    private static final Pattern KEY_PERMISSION = Pattern.compile("(?i)(meet-?)?perm(ission)?");
    private static final Pattern KEY_EXECUTION = Pattern.compile("(?i)run|(run-?)?(cmds?|commands?)|execut(e|ions?)");

    @Nullable
    public static Execution of(Object object) {
        if (object instanceof String) {
            return new SimpleExecution((String)object);
        }
        if (object instanceof Iterable) {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (Object o : (Iterable)object) {
                Execution execution = Execution.of(o);
                if (execution == null) continue;
                executions.add(execution);
            }
            if (!executions.isEmpty()) {
                return new AdvancedExecution(0.0, false, null, executions);
            }
        } else if (object instanceof Map) {
            double chance = 0.0;
            boolean cancelling = false;
            String permission = null;
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Execution execution;
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                if (KEY_CHANCE.matcher(key).matches()) {
                    try {
                        chance = Double.parseDouble(String.valueOf(value));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (KEY_CANCEL.matcher(key).matches()) {
                    cancelling = String.valueOf(value).equalsIgnoreCase("true");
                    continue;
                }
                if (KEY_PERMISSION.matcher(key).matches()) {
                    permission = String.valueOf(value);
                    continue;
                }
                if (!KEY_EXECUTION.matcher(key).matches() || (execution = Execution.of(value)) == null) continue;
                executions.add(execution);
            }
            if (!executions.isEmpty()) {
                return new AdvancedExecution(chance, cancelling, permission, executions);
            }
        }
        return null;
    }

    public void run(Player player, Player agent, Function<String, String> parser, boolean console) {
        this.run((CommandSender)(console ? Bukkit.getConsoleSender() : player), player, agent, parser);
    }

    public abstract boolean run(CommandSender var1, Player var2, Player var3, Function<String, String> var4);

    public void run(CommandSender sender, Player player, Player agent, String cmd, Function<String, String> parser) {
        String s = parser.apply(cmd);
        if (USE_PLACEHOLDERAPI.get().booleanValue() && ExpensiveDeaths.getInstance().getConfig().getBoolean("bonus.parse-placeholders")) {
            s = PlaceholderAPI.setPlaceholders((Player)player, (String)s);
            if (agent != null) {
                s = PlaceholderAPI.setBracketPlaceholders((Player)agent, (String)s);
            }
        }
        Bukkit.dispatchCommand((CommandSender)sender, (String)s);
    }

    public static class SimpleExecution
    extends Execution {
        private final String cmd;

        public SimpleExecution(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public boolean run(CommandSender sender, Player player, Player agent, Function<String, String> parser) {
            this.run(sender, player, agent, this.cmd, parser);
            return false;
        }
    }

    public static class AdvancedExecution
    extends Execution {
        private final double chance;
        private final boolean cancelling;
        private final String permission;
        private final List<Execution> executions;

        public AdvancedExecution(double chance, boolean cancelling, String permission, List<Execution> executions) {
            this.chance = chance;
            this.cancelling = cancelling;
            this.permission = permission;
            this.executions = executions;
        }

        public boolean testChance() {
            return this.chance == 0.0 || ThreadLocalRandom.current().nextDouble() <= this.chance;
        }

        public boolean meetPermission(Player player) {
            if (this.permission != null) {
                for (String s : this.permission.split(";")) {
                    if (player.hasPermission(s.trim())) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean run(CommandSender sender, Player player, Player agent, Function<String, String> parser) {
            if (!this.testChance() || !this.meetPermission(player)) {
                return false;
            }
            for (Execution execution : this.executions) {
                if (execution.run(sender, player, agent, parser)) break;
            }
            return this.cancelling;
        }
    }

    public static enum Type {
        DEATH_PLAYER,
        DEATH_CONSOLE,
        KILL_PLAYER,
        KILL_CONSOLE,
        RESPAWN_PLAYER,
        RESPAWN_CONSOLE;


        public boolean isConsole() {
            return this == DEATH_CONSOLE || this == KILL_CONSOLE || this == RESPAWN_CONSOLE;
        }
    }
}

