/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.expensivedeaths;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.silverstonemc.expensivedeaths.DeathEvent;
import net.silverstonemc.expensivedeaths.Execution;
import net.silverstonemc.expensivedeaths.RespawnEvent;
import net.silverstonemc.expensivedeaths.UpdateChecker;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ExpensiveDeaths
extends JavaPlugin
implements Listener,
CommandExecutor {
    private Economy econ;
    private Permission perms;
    private final Map<Execution.Type, Execution> executions = new HashMap<Execution.Type, Execution>();
    private static ExpensiveDeaths instance;

    public static ExpensiveDeaths getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.setupEconomy();
        this.setupPermissions();
        this.saveDefaultConfig();
        this.loadExecutions();
        this.getServer().getPluginManager().registerEvents((Listener)new DeathEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateChecker(this), (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                String latest = new UpdateChecker(instance).getLatestVersion();
                String current = instance.getDescription().getVersion();
                if (latest == null) {
                    return;
                }
                if (!current.equals(latest)) {
                    new UpdateChecker(instance).logUpdate(current, latest);
                }
            }
        }.runTaskLaterAsynchronously((Plugin)this, 5L);
    }

    public boolean onCommand(CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.loadExecutions();
        sender.sendMessage(ChatColor.GREEN + "ExpensiveDeaths reloaded!");
        return true;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public Permission getPermissions() {
        return this.perms;
    }

    public void run(Execution.Type type, Player player, Player agent, Function<String, String> parser) {
        Execution execution = this.executions.get((Object)type);
        if (execution != null) {
            execution.run(player, agent, parser, type.isConsole());
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.econ = (Economy)rsp.getProvider();
    }

    private void setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            return;
        }
        this.perms = (Permission)rsp.getProvider();
    }

    private void loadExecutions() {
        this.executions.clear();
        this.loadExecution(Execution.Type.DEATH_CONSOLE, "console-commands-on-death");
        this.loadExecution(Execution.Type.DEATH_PLAYER, "player-commands-on-death");
        this.loadExecution(Execution.Type.KILL_CONSOLE, "console-commands-on-killed");
        this.loadExecution(Execution.Type.KILL_PLAYER, "player-commands-on-killed");
        this.loadExecution(Execution.Type.RESPAWN_CONSOLE, "console-commands-on-respawn");
        this.loadExecution(Execution.Type.RESPAWN_PLAYER, "player-commands-on-respawn");
    }

    private void loadExecution(Execution.Type type, String key) {
        Execution execution = Execution.of(this.getConfig().get("bonus." + key));
        if (execution != null) {
            this.executions.put(type, execution);
        }
    }
}

