/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.expensivedeaths;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.silverstonemc.expensivedeaths.shaded.json.JSONObject;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onJoin(final PlayerJoinEvent event) {
        final String pluginName = this.plugin.getDescription().getName();
        if (event.getPlayer().hasPermission(pluginName.toLowerCase() + ".updatenotifs")) {
            new BukkitRunnable(){

                public void run() {
                    String latest = UpdateChecker.this.getLatestVersion();
                    String current = UpdateChecker.this.plugin.getDescription().getVersion();
                    if (latest == null) {
                        return;
                    }
                    if (!current.equals(latest)) {
                        event.getPlayer().sendMessage(ChatColor.YELLOW + "An update is available for " + pluginName + "! " + ChatColor.GOLD + "(" + current + " \u2192 " + latest + ")\n" + ChatColor.DARK_AQUA + "https://github.com/SilverstoneMC/" + pluginName + "/releases/latest");
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    @Nullable
    public String getLatestVersion() {
        String pluginName = this.plugin.getDescription().getName();
        try {
            InputStream url = new URI("https://api.github.com/repos/SilverstoneMC/" + pluginName + "/releases/latest").toURL().openStream();
            JSONObject response = new JSONObject(new String(url.readAllBytes(), StandardCharsets.UTF_8));
            url.close();
            return response.getString("tag_name");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void logUpdate(String current, String latest) {
        String pluginName = this.plugin.getDescription().getName();
        this.plugin.getLogger().warning("An update is available for " + pluginName + "! (" + current + " \u2192 " + latest + ")");
        this.plugin.getLogger().warning("https://github.com/SilverstoneMC/" + pluginName + "/releases/latest");
    }
}

