/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.database;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;
import org.sqlite.SQLiteConfig;

public class SqLiteDatabase
extends Database {
    private final Path databaseFile;
    private static final String DATABASE_FILE_NAME = "HuskHomesData.db";
    private Connection connection;

    public SqLiteDatabase(@NotNull HuskHomes plugin) {
        super(plugin);
        this.databaseFile = plugin.getConfigDirectory().resolve(DATABASE_FILE_NAME);
    }

    @NotNull
    private Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.setConnection();
        }
        return this.connection;
    }

    private void setConnection() {
        try {
            if (this.databaseFile.toFile().createNewFile()) {
                this.plugin.log(Level.INFO, "Created the SQLite database file", new Throwable[0]);
            }
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            config.setEncoding(SQLiteConfig.Encoding.UTF8);
            config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", this.databaseFile.toAbsolutePath()), config.toProperties());
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "An exception occurred creating the database file", e);
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "An SQL exception occurred initializing the SQLite database", e);
        }
        catch (ClassNotFoundException e) {
            this.plugin.log(Level.SEVERE, "Failed to load the necessary SQLite driver", e);
        }
    }

    @Override
    protected void executeScript(@NotNull Connection connection, @NotNull String name) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String schemaStatement : this.getScript(name)) {
                statement.execute(schemaStatement);
            }
        }
    }

    @Override
    public void initialize() throws RuntimeException {
        this.setConnection();
        this.backupFlatFile(this.databaseFile);
        if (!this.isCreated()) {
            this.plugin.log(Level.INFO, "Creating SQLite database tables", new Throwable[0]);
            try {
                this.executeScript(this.getConnection(), "sqlite_schema.sql");
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to create SQLite database tables", new Throwable[0]);
                this.setLoaded(false);
                return;
            }
            this.setSchemaVersion(Database.Migration.getLatestVersion());
            this.plugin.log(Level.INFO, "SQLite database tables created!", new Throwable[0]);
            this.setLoaded(true);
            return;
        }
        try {
            this.performMigrations(this.getConnection(), Database.Type.SQLITE);
            this.setLoaded(true);
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to perform SQLite database migrations", new Throwable[0]);
            this.setLoaded(false);
        }
    }

    @Override
    public boolean isCreated() {
        boolean bl;
        block9: {
            if (!this.databaseFile.toFile().exists()) {
                return false;
            }
            PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `uuid`\nFROM `%player_data%`\nLIMIT 1;"));
            try {
                statement.executeQuery();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSchemaVersion() {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `schema_version`\nFROM `%meta_data%`\nLIMIT 1;"));){
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return -1;
            int n = resultSet.getInt("schema_version");
            return n;
        }
        catch (SQLException e) {
            this.plugin.log(Level.WARNING, "The database schema version could not be fetched; migrations will be carried out.", new Throwable[0]);
        }
        return -1;
    }

    @Override
    public void setSchemaVersion(int version) {
        if (this.getSchemaVersion() == -1) {
            try (PreparedStatement insertStatement = this.getConnection().prepareStatement(this.format("INSERT INTO `%meta_data%` (`schema_version`)\nVALUES (?);"));){
                insertStatement.setInt(1, version);
                insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to insert schema version in table", e);
            }
            return;
        }
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("UPDATE `%meta_data%`\nSET `schema_version` = ?;"));){
            statement.setInt(1, version);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update schema version in table", e);
        }
    }

    @Override
    protected int setPosition(@NotNull Position position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%position_data%`\n    (`x`,`y`,`z`,`yaw`,`pitch`,`world_name`,`world_uuid`,`server_name`)\nVALUES\n    (?,?,?,?,?,?,?,?)\nRETURNING `id`;"));){
            statement.setDouble(1, position.getX());
            statement.setDouble(2, position.getY());
            statement.setDouble(3, position.getZ());
            statement.setFloat(4, position.getYaw());
            statement.setFloat(5, position.getPitch());
            statement.setString(6, position.getWorld().getName());
            statement.setString(7, position.getWorld().getUuid().toString());
            statement.setString(8, position.getServer());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt("id");
                    return n;
                }
            }
            throw new SQLException("No generated ID found");
        }
    }

    @Override
    protected void updatePosition(int positionId, @NotNull Position position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%position_data%`\nSET `x`=?,\n`y`=?,\n`z`=?,\n`yaw`=?,\n`pitch`=?,\n`world_uuid`=?,\n`world_name`=?,\n`server_name`=?\nWHERE `id`=?"));){
            statement.setDouble(1, position.getX());
            statement.setDouble(2, position.getY());
            statement.setDouble(3, position.getZ());
            statement.setFloat(4, position.getYaw());
            statement.setFloat(5, position.getPitch());
            statement.setString(6, position.getWorld().getUuid().toString());
            statement.setString(7, position.getWorld().getName());
            statement.setString(8, position.getServer());
            statement.setDouble(9, positionId);
            statement.executeUpdate();
        }
    }

    @Override
    protected int setSavedPosition(@NotNull SavedPosition position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%saved_position_data%`\n    (`position_id`, `name`, `description`, `tags`, `timestamp`)\nVALUES\n    (?,?,?,?,?)\nRETURNING `id`;"));){
            statement.setInt(1, this.setPosition(position, connection));
            statement.setString(2, position.getName());
            statement.setString(3, position.getMeta().getDescription());
            statement.setString(4, position.getMeta().getSerializedTags());
            statement.setTimestamp(5, Timestamp.from(position.getMeta().getCreationTime()));
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt("id");
                    return n;
                }
            }
            throw new SQLException("No generated ID found");
        }
    }

    @Override
    protected void updateSavedPosition(int savedPositionId, @NotNull SavedPosition position, @NotNull Connection connection) throws SQLException {
        block12: {
            try (PreparedStatement selectStatement = connection.prepareStatement(this.format("SELECT `position_id`\nFROM `%saved_position_data%`\nWHERE `id`=?;"));){
                selectStatement.setInt(1, savedPositionId);
                ResultSet resultSet = selectStatement.executeQuery();
                if (!resultSet.next()) break block12;
                int positionId = resultSet.getInt("position_id");
                this.updatePosition(positionId, position, connection);
                try (PreparedStatement updateStatement = connection.prepareStatement(this.format("UPDATE `%saved_position_data%`\nSET `name`=?,\n`description`=?,\n`tags`=?\nWHERE `id`=?;"));){
                    updateStatement.setString(1, position.getName());
                    updateStatement.setString(2, position.getMeta().getDescription());
                    updateStatement.setString(3, position.getMeta().getSerializedTags());
                    updateStatement.setInt(4, savedPositionId);
                    updateStatement.executeUpdate();
                }
            }
        }
    }

    @Override
    public void ensureUser(@NotNull User onlineUser) {
        this.getUser(onlineUser.getUuid()).ifPresentOrElse(existingUser -> {
            if (!existingUser.getUsername().equals(onlineUser.getName())) {
                try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("UPDATE `%player_data%`\nSET `username`=?\nWHERE `uuid`=?"));){
                    statement.setString(1, onlineUser.getName());
                    statement.setString(2, existingUser.getUserUuid().toString());
                    statement.executeUpdate();
                    this.plugin.log(Level.INFO, "Updated " + onlineUser.getName() + "'s name in the database (" + existingUser.getUsername() + " -> " + onlineUser.getName() + ")", new Throwable[0]);
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to update a player's name on the database", e);
                }
            }
        }, () -> {
            try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%player_data%` (`uuid`,`username`)\nVALUES (?,?);"));){
                statement.setString(1, onlineUser.getUuid().toString());
                statement.setString(2, onlineUser.getName());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to insert a player into the database", e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SavedUser> getUser(@NotNull String name) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `uuid`, `username`, `home_slots`, `ignoring_requests`\nFROM `%player_data%`\nWHERE `username`=?"));){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<SavedUser> optional = Optional.of(new SavedUser(User.of(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")), resultSet.getInt("home_slots"), resultSet.getBoolean("ignoring_requests")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player by name from the database", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SavedUser> getUser(@NotNull UUID uuid) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `uuid`, `username`, `home_slots`, `ignoring_requests`\nFROM `%player_data%`\nWHERE `uuid`=?"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<SavedUser> optional = Optional.of(new SavedUser(User.of(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")), resultSet.getInt("home_slots"), resultSet.getBoolean("ignoring_requests")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player from uuid from the database", e);
        }
        return Optional.empty();
    }

    @Override
    public void deleteUser(@NotNull UUID uuid) {
        PreparedStatement statement;
        try {
            statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `id`\n    IN ((SELECT `last_position` FROM `%player_data%` WHERE `uuid` = ?),\n        (SELECT `offline_position` FROM `%player_data%` WHERE `uuid` = ?),\n        (SELECT `respawn_position` FROM `%player_data%` WHERE `uuid` = ?));"));
            try {
                statement.setString(1, uuid.toString());
                statement.setString(2, uuid.toString());
                statement.setString(3, uuid.toString());
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete player positions from the database", e);
            return;
        }
        try {
            statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%player_data%`\nWHERE `uuid`=?;"));
            try {
                statement.setString(1, uuid.toString());
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a player from the database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Instant> getCooldown(@NotNull TransactionResolver.Action action, @NotNull User user) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `type`, `start_timestamp`, `end_timestamp`\nFROM `%player_cooldowns_data%`\nWHERE `player_uuid`=? AND `type`=?\nORDER BY `start_timestamp` DESC\nLIMIT 1;"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Instant> optional = Optional.of(resultSet.getTimestamp("end_timestamp").toInstant());
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player's cooldown from the database", e);
        }
        return Optional.empty();
    }

    @Override
    public void removeCooldown(@NotNull TransactionResolver.Action action, @NotNull User user) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%player_cooldowns_data%`\nWHERE `player_uuid`=? AND `type`=?;"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to remove a player's cooldown from the database", e);
        }
    }

    @Override
    public void setCooldown(@NotNull TransactionResolver.Action action, @NotNull User user, @NotNull Instant cooldownExpiry) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%player_cooldowns_data%` (`player_uuid`, `type`, `start_timestamp`, `end_timestamp`)\nVALUES (?,?,?,?);"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            statement.setTimestamp(3, Timestamp.from(Instant.now()));
            statement.setTimestamp(4, Timestamp.from(cooldownExpiry));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to set a player's cooldown in the database", e);
        }
    }

    @Override
    public List<Home> getHomes(@NotNull User user) {
        ArrayList<Home> userHomes = new ArrayList<Home>();
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%home_data%`.`uuid` AS `home_uuid`, `owner_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`, `public`\nFROM `%home_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%home_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nINNER JOIN `%player_data%`\n    ON `%home_data%`.`owner_uuid`=`%player_data%`.`uuid`\nWHERE `owner_uuid`=?\nORDER BY `name`;"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                userHomes.add(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), user, resultSet.getBoolean("public")));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for home data for:" + user.getName(), new Throwable[0]);
        }
        return userHomes;
    }

    @Override
    public List<Warp> getWarps() {
        ArrayList<Warp> warps = new ArrayList<Warp>();
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%warp_data%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warp_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%warp_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nORDER BY `name`;"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                warps.add(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for warp data.", new Throwable[0]);
        }
        return warps;
    }

    @Override
    public List<Home> getPublicHomes() {
        ArrayList<Home> userHomes = new ArrayList<Home>();
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%home_data%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%home_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%home_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nINNER JOIN `%player_data%`\n    ON `%home_data%`.`owner_uuid`=`%player_data%`.`uuid`\nWHERE `public`=true\nORDER BY `name`;"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                userHomes.add(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), User.of(UUID.fromString(resultSet.getString("owner_uuid")), resultSet.getString("owner_username")), resultSet.getBoolean("public")));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for public home data", new Throwable[0]);
        }
        return userHomes;
    }

    @Override
    public List<Home> getPublicHomes(@NotNull String name, boolean caseInsensitive) {
        ArrayList<Home> userHomes = new ArrayList<Home>();
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%home_data%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%home_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%home_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nINNER JOIN `%player_data%`\n    ON `%home_data%`.`owner_uuid`=`%player_data%`.`uuid`\nWHERE `public`=true\nAND ((? AND UPPER(`name`) LIKE UPPER(?)) OR (`name`=?))\nORDER BY `name`;"));){
            statement.setBoolean(1, caseInsensitive);
            statement.setString(2, name);
            statement.setString(3, name);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                userHomes.add(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), User.of(UUID.fromString(resultSet.getString("owner_uuid")), resultSet.getString("owner_username")), resultSet.getBoolean("public")));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for public home data", new Throwable[0]);
        }
        return userHomes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Home> getHome(@NotNull User user, @NotNull String homeName, boolean caseInsensitive) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%home_data%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%home_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%home_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nINNER JOIN `%player_data%`\n    ON `%home_data%`.`owner_uuid`=`%player_data%`.`uuid`\nWHERE `owner_uuid`=?\nAND ((? AND UPPER(`name`) LIKE UPPER(?)) OR (`name`=?))"));){
            statement.setString(1, user.getUuid().toString());
            statement.setBoolean(2, caseInsensitive);
            statement.setString(3, homeName);
            statement.setString(4, homeName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Home> optional = Optional.of(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), user, resultSet.getBoolean("public")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a player's home", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Home> getHome(@NotNull UUID uuid) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%home_data%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%home_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%home_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nINNER JOIN `%player_data%`\n    ON `%home_data%`.`owner_uuid`=`%player_data%`.`uuid`\nWHERE `%home_data%`.`uuid`=?;"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Home> optional = Optional.of(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), User.of(UUID.fromString(resultSet.getString("owner_uuid")), resultSet.getString("owner_username")), resultSet.getBoolean("public")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a player's home by uuid", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Warp> getWarp(@NotNull String warpName, boolean caseInsensitive) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%warp_data%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warp_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%warp_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nAND ((? AND UPPER(`name`) LIKE UPPER(?)) OR (`name`=?))"));){
            statement.setBoolean(1, caseInsensitive);
            statement.setString(2, warpName);
            statement.setString(3, warpName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Warp> optional = Optional.of(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a server warp", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Warp> getWarp(@NotNull UUID uuid) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `%warp_data%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warp_data%`\nINNER JOIN `%saved_position_data%`\n    ON `%warp_data%`.`saved_position_id`=`%saved_position_data%`.`id`\nINNER JOIN `%position_data%`\n    ON `%saved_position_data%`.`position_id`=`%position_data%`.`id`\nWHERE `%warp_data%`.uuid=?;"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Warp> optional = Optional.of(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a server warp", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Teleport> getCurrentTeleport(@NotNull OnlineUser onlineUser) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`, `type`\nFROM `%teleport_data%`\nINNER JOIN `%position_data%` ON `%teleport_data%`.`destination_id` = `%position_data%`.`id`\nWHERE `player_uuid`=?"));){
            statement.setString(1, onlineUser.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Teleport> optional = Optional.of(Teleport.builder(this.plugin).teleporter(onlineUser).target(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"))).type(Teleport.Type.getTeleportType(resultSet.getInt("type")).orElse(Teleport.Type.TELEPORT)).updateLastPosition(false).toTeleport());
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the current teleport of " + onlineUser.getName(), e);
            return Optional.empty();
        }
        catch (TeleportationException e) {
            e.displayMessage(onlineUser, new String[0]);
        }
        return Optional.empty();
    }

    @Override
    public void updateUserData(@NotNull SavedUser savedUser) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("UPDATE `%player_data%`\nSET `home_slots`=?, `ignoring_requests`=?\nWHERE `uuid`=?"));){
            statement.setInt(1, savedUser.getHomeSlots());
            statement.setBoolean(2, savedUser.isIgnoringTeleports());
            statement.setString(3, savedUser.getUserUuid().toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update user data for " + savedUser.getUsername(), e);
        }
    }

    @Override
    public void setCurrentTeleport(@NotNull User user, @Nullable Teleport teleport) {
        try (PreparedStatement deleteStatement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `id`=(\n    SELECT `destination_id`\n    FROM `%teleport_data%`\n    WHERE `%teleport_data%`.`player_uuid`=?\n);"));){
            deleteStatement.setString(1, user.getUuid().toString());
            deleteStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to clear the current teleport of " + user.getName(), e);
        }
        if (teleport != null) {
            try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%teleport_data%` (`player_uuid`, `destination_id`, `type`)\nVALUES (?,?,?);"));){
                statement.setString(1, user.getUuid().toString());
                statement.setInt(2, this.setPosition((Position)teleport.getTarget(), this.connection));
                statement.setInt(3, teleport.getType().getTypeId());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the current teleport of " + user.getName(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getLastPosition(@NotNull User user) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.`last_position` = `%position_data%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the last teleport position of " + user.getName(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setLastPosition(@NotNull User user, @NotNull Position position) {
        block15: {
            try (PreparedStatement queryStatement = this.getConnection().prepareStatement(this.format("SELECT `last_position` FROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.last_position = `%position_data%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    this.updatePosition(resultSet.getInt("last_position"), position, this.connection);
                    break block15;
                }
                try (PreparedStatement updateStatement = this.getConnection().prepareStatement(this.format("UPDATE `%player_data%`\nSET `last_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, this.connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the last position of " + user.getName(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getOfflinePosition(@NotNull User user) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.`offline_position` = `%position_data%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the offline position of " + user.getName(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setOfflinePosition(@NotNull User user, @NotNull Position position) {
        block15: {
            try (PreparedStatement queryStatement = this.getConnection().prepareStatement(this.format("SELECT `offline_position` FROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.offline_position = `%position_data%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    this.updatePosition(resultSet.getInt("offline_position"), position, this.connection);
                    break block15;
                }
                try (PreparedStatement updateStatement = this.getConnection().prepareStatement(this.format("UPDATE `%player_data%`\nSET `offline_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, this.connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the offline position of " + user.getName(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getRespawnPosition(@NotNull User user) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.`respawn_position` = `%position_data%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the respawn position of " + user.getName(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setRespawnPosition(@NotNull User user, @Nullable Position position) {
        block22: {
            try (PreparedStatement queryStatement = this.getConnection().prepareStatement(this.format("SELECT `respawn_position` FROM `%player_data%`\nINNER JOIN `%position_data%` ON `%player_data%`.respawn_position = `%position_data%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    if (position == null) {
                        try (PreparedStatement deleteStatement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `id`=(\n    SELECT `respawn_position`\n    FROM `%player_data%`\n    WHERE `%player_data%`.`uuid`=?\n);"));){
                            deleteStatement.setString(1, user.getUuid().toString());
                            deleteStatement.executeUpdate();
                            break block22;
                        }
                    }
                    this.updatePosition(resultSet.getInt("respawn_position"), position, this.connection);
                    break block22;
                }
                if (position == null) break block22;
                try (PreparedStatement updateStatement = this.getConnection().prepareStatement(this.format("UPDATE `%player_data%`\nSET `respawn_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, this.connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the respawn position of " + user.getName(), e);
            }
        }
    }

    @Override
    public void saveHome(@NotNull Home home) {
        this.getHome(home.getUuid()).ifPresentOrElse(presentHome -> {
            try {
                try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `saved_position_id` FROM `%home_data%`\nWHERE `uuid`=?;"));){
                    statement.setString(1, home.getUuid().toString());
                    ResultSet resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        this.updateSavedPosition(resultSet.getInt("saved_position_id"), home, this.connection);
                    }
                }
                statement = this.connection.prepareStatement(this.format("UPDATE `%home_data%`\nSET `public`=?\nWHERE `uuid`=?;"));
                try {
                    statement.setBoolean(1, home.isPublic());
                    statement.setString(2, home.getUuid().toString());
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to update a home in the database for " + home.getOwner().getName(), e);
            }
        }, () -> {
            try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%home_data%` (`uuid`, `saved_position_id`, `owner_uuid`, `public`)\nVALUES (?,?,?,?);"));){
                statement.setString(1, home.getUuid().toString());
                statement.setInt(2, this.setSavedPosition(home, this.connection));
                statement.setString(3, home.getOwner().getUuid().toString());
                statement.setBoolean(4, home.isPublic());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set home for " + home.getOwner().getName(), e);
            }
        });
    }

    @Override
    public void saveWarp(@NotNull Warp warp) {
        this.getWarp(warp.getUuid()).ifPresentOrElse(presentWarp -> {
            try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("SELECT `saved_position_id` FROM `%warp_data%`\nWHERE `uuid`=?;"));){
                statement.setString(1, warp.getUuid().toString());
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    this.updateSavedPosition(resultSet.getInt("saved_position_id"), warp, this.connection);
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to update a warp in the database", e);
            }
        }, () -> {
            try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("INSERT INTO `%warp_data%` (`uuid`, `saved_position_id`)\nVALUES (?,?);"));){
                statement.setString(1, warp.getUuid().toString());
                statement.setInt(2, this.setSavedPosition(warp, this.connection));
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to add a warp to the database", e);
            }
        });
    }

    @Override
    public void deleteHome(@NotNull UUID uuid) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id`=(\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id`=(\n        SELECT `saved_position_id`\n        FROM `%home_data%`\n        WHERE `uuid`=?\n    )\n);"));){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a home from the database", e);
        }
    }

    @Override
    public int deleteAllHomes(@NotNull User user) {
        int n;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%home_data%`\n        WHERE `owner_uuid`=?\n    )\n);"));
            try {
                statement.setString(1, user.getUuid().toString());
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to delete all homes for " + user.getName() + " from the database", e);
                    return 0;
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public int deleteAllHomes(@NotNull String worldName, @NotNull String serverName) {
        int n;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%home_data%`\n        WHERE `world_name`=?\n        AND `server_name`=?\n    )\n);"));
            try {
                statement.setString(1, worldName);
                statement.setString(2, serverName);
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to delete homes in the world " + worldName + " on the server " + serverName + " from the database", e);
                    return 0;
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public void deleteWarp(@NotNull UUID uuid) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id`=(\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id`=(\n        SELECT `saved_position_id`\n        FROM `%warp_data%`\n        WHERE `uuid`=?\n    )\n);"));){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a warp from the database", e);
        }
    }

    @Override
    public int deleteAllWarps() {
        int n;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%warp_data%`\n    )\n);"));
            try {
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to delete all warps from the database", e);
                    return 0;
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public int deleteAllWarps(@NotNull String worldName, @NotNull String serverName) {
        int n;
        block8: {
            PreparedStatement statement = this.getConnection().prepareStatement(this.format("DELETE FROM `%position_data%`\nWHERE `%position_data%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_position_data%`\n    WHERE `%saved_position_data%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%warp_data%`\n        WHERE `world_name`=?\n        AND `server_name`=?\n    )\n);"));
            try {
                statement.setString(1, worldName);
                statement.setString(2, serverName);
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to delete warps in the world " + worldName + " on the server " + serverName + " from the database", e);
                    return 0;
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.WARNING, "Failed to properly close the SQLite connection", new Throwable[0]);
        }
    }
}

