/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.List;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.SavedUser;
import org.bukkit.OfflinePlayer;

@PluginHook(name="PlaceholderAPI", register=PluginHook.Register.ON_ENABLE)
public class PlaceholderAPIHook
extends Hook {
    public PlaceholderAPIHook(@NotNull BukkitHuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        new HuskHomesExpansion((BukkitHuskHomes)this.plugin, this.plugin.getPluginVersion().toStringWithoutMetadata()).register();
    }

    @Override
    public void unload() {
    }

    public static class HuskHomesExpansion
    extends PlaceholderExpansion {
        @NotNull
        private final BukkitHuskHomes plugin;
        private final String version;
        private final String author = "William278";
        private final String identifier = "huskhomes";

        @Nullable
        public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
            if (offlinePlayer == null || !offlinePlayer.isOnline() || offlinePlayer.getPlayer() == null) {
                return "Player not online";
            }
            BukkitUser player = this.plugin.getOnlineUser(offlinePlayer.getPlayer());
            return switch (params) {
                case "homes_count" -> String.valueOf(this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getName(), List.of()).size());
                case "max_homes" -> String.valueOf(this.plugin.getManager().homes().getMaxHomes(player));
                case "max_public_homes" -> String.valueOf(this.plugin.getManager().homes().getMaxPublicHomes(player));
                case "free_home_slots" -> String.valueOf(this.plugin.getManager().homes().getFreeHomes(player));
                case "home_slots" -> String.valueOf(this.plugin.getSavedUser(player).map(SavedUser::getHomeSlots).orElse(0));
                case "homes_list" -> String.join((CharSequence)", ", this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getName(), List.of()));
                case "public_homes_count" -> String.valueOf(this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getName(), List.of()).size());
                case "public_homes_list" -> String.join((CharSequence)", ", this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getName(), List.of()));
                case "ignoring_tp_requests" -> this.getBooleanValue(this.plugin.getManager().requests().isIgnoringRequests(player));
                default -> null;
            };
        }

        @NotNull
        private String getBooleanValue(boolean bool) {
            return bool ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getAuthor() {
            return this.author;
        }

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public HuskHomesExpansion(@NotNull BukkitHuskHomes plugin, String version) {
            if (plugin == null) {
                throw new NullPointerException("plugin is marked non-null but is null");
            }
            this.plugin = plugin;
            this.version = version;
        }
    }
}

