/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.event.ITeleportWarmupCancelledEvent;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Completable;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.Task;
import net.william278.huskhomes.util.TransactionResolver;

public class TimedTeleport
extends Teleport
implements Runnable,
Completable {
    public static final String BYPASS_PERMISSION = "huskhomes.bypass_teleport_warmup";
    private final OnlineUser teleporter;
    private final Position startLocation;
    private final double startHealth;
    private final int warmupTime;
    private Task.Repeating task;
    private int timeLeft;

    protected TimedTeleport(@NotNull OnlineUser executor, @NotNull OnlineUser teleporter, @NotNull Target target, @NotNull Teleport.Type type, int warmupTime, boolean updateLastPosition, @NotNull List<TransactionResolver.Action> actions, @NotNull HuskHomes plugin) {
        super(teleporter, executor, target, type, updateLastPosition, actions, plugin);
        this.startLocation = teleporter.getPosition();
        this.startHealth = teleporter.getHealth();
        this.warmupTime = warmupTime;
        this.timeLeft = Math.max(warmupTime, 0);
        this.teleporter = teleporter;
    }

    @Override
    public void execute() throws TeleportationException {
        if (this.timeLeft == 0 || this.teleporter.hasPermission(BYPASS_PERMISSION)) {
            super.execute();
            return;
        }
        if (this.plugin.isWarmingUp(this.teleporter.getUuid())) {
            throw new TeleportationException(TeleportationException.Type.ALREADY_WARMING_UP, this.plugin);
        }
        this.validateTransactions();
        if (this.teleporter.isMoving()) {
            throw new TeleportationException(TeleportationException.Type.WARMUP_ALREADY_MOVING, this.plugin);
        }
        this.process();
    }

    private void process() {
        this.plugin.fireEvent(this.plugin.getTeleportWarmupEvent(this, this.timeLeft), event -> {
            this.plugin.getCurrentlyOnWarmup().add(this.teleporter.getUuid());
            this.plugin.getLocales().getLocale("teleporting_warmup_start", Integer.toString(this.timeLeft)).ifPresent(this.teleporter::sendMessage);
            this.task = this.plugin.getRepeatingTask(this, 20L);
            this.task.run();
        });
    }

    @Override
    public void run() {
        if (this.timeLeft > 0) {
            this.plugin.getSettings().getGeneral().getSoundEffects().get(Settings.SoundEffectAction.TELEPORTATION_WARMUP).ifPresent(this.teleporter::playSound);
            this.plugin.getLocales().getLocale("teleporting_action_bar_warmup", Integer.toString(this.timeLeft)).ifPresent(this::sendStatusMessage);
        } else {
            this.plugin.getLocales().getLocale("teleporting_action_bar_processing").ifPresent(this::sendStatusMessage);
            try {
                super.execute();
            }
            catch (TeleportationException e) {
                e.displayMessage(this.teleporter, new String[0]);
                this.task.cancel();
                this.plugin.getCurrentlyOnWarmup().remove(this.teleporter.getUuid());
                return;
            }
        }
        if (this.tickAndGetIfDone()) {
            this.task.cancel();
            this.plugin.getCurrentlyOnWarmup().remove(this.teleporter.getUuid());
        }
    }

    private boolean tickAndGetIfDone() {
        if (this.timeLeft <= 0) {
            return true;
        }
        if (this.hasTeleporterTakenDamage() && this.plugin.getSettings().getGeneral().isTeleportWarmupCancelOnDamage()) {
            this.plugin.fireEvent(this.plugin.getTeleportWarmupCancelledEvent(this, this.warmupTime, this.timeLeft, ITeleportWarmupCancelledEvent.CancelReason.PLAYER_DAMAGE), null);
            this.plugin.getLocales().getLocale("teleporting_cancelled_damage").ifPresent(this.teleporter::sendMessage);
            this.plugin.getLocales().getLocale("teleporting_action_bar_cancelled").ifPresent(this::sendStatusMessage);
            this.plugin.getSettings().getGeneral().getSoundEffects().get(Settings.SoundEffectAction.TELEPORTATION_CANCELLED).ifPresent(this.teleporter::playSound);
            return true;
        }
        if (this.hasTeleporterMoved() && this.plugin.getSettings().getGeneral().isTeleportWarmupCancelOnMove()) {
            this.plugin.fireEvent(this.plugin.getTeleportWarmupCancelledEvent(this, this.warmupTime, this.timeLeft, ITeleportWarmupCancelledEvent.CancelReason.PLAYER_MOVE), null);
            this.plugin.getLocales().getLocale("teleporting_cancelled_movement").ifPresent(this.teleporter::sendMessage);
            this.plugin.getLocales().getLocale("teleporting_action_bar_cancelled").ifPresent(this::sendStatusMessage);
            this.plugin.getSettings().getGeneral().getSoundEffects().get(Settings.SoundEffectAction.TELEPORTATION_CANCELLED).ifPresent(this.teleporter::playSound);
            return true;
        }
        --this.timeLeft;
        return false;
    }

    private void sendStatusMessage(@NotNull MineDown message) {
        this.teleporter.sendMessage(message, this.plugin.getSettings().getGeneral().getTeleportWarmupDisplay());
    }

    private boolean hasTeleporterMoved() {
        double maxMovementDistance = 0.1;
        double movementDistance = Math.abs(this.startLocation.getX() - this.teleporter.getPosition().getX()) + Math.abs(this.startLocation.getY() - this.teleporter.getPosition().getY()) + Math.abs(this.startLocation.getZ() - this.teleporter.getPosition().getZ());
        return movementDistance > 0.1;
    }

    private boolean hasTeleporterTakenDamage() {
        return this.teleporter.getHealth() < this.startHealth;
    }
}

