/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.agriculture;

import java.awt.Color;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.IngredientMapper;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.registry.GuiItems;
import xyz.xenondevs.nova.addon.machines.tileentity.agriculture.PlantConfiguration;
import xyz.xenondevs.nova.addon.machines.tileentity.agriculture.TreeFactoryKt;
import xyz.xenondevs.nova.addon.machines.util.TileEntityUtilsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.ExtensionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeHolder;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeType;
import xyz.xenondevs.nova.addon.simpleupgrades.gui.OpenUpgradesItem;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.config.GlobalValues;
import xyz.xenondevs.nova.ui.menu.EnergyBar;
import xyz.xenondevs.nova.ui.menu.StructureIngredientsKt;
import xyz.xenondevs.nova.ui.menu.sideconfig.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenu;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenuKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.holder.DefaultEnergyHolder;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.holder.DefaultItemHolder;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;
import xyz.xenondevs.nova.world.item.NovaItem;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020+H\u0016J\b\u0010.\u001a\u00020+H\u0002J\u0010\u0010/\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0018\u001a\u0004\b \u0010!R\u0015\u0010#\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/agriculture/TreeFactory;", "Lxyz/xenondevs/nova/world/block/tileentity/NetworkedTileEntity;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "data", "Lxyz/xenondevs/cbf/Compound;", "<init>", "(Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;Lxyz/xenondevs/cbf/Compound;)V", "inputInventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "outputInventory", "upgradeHolder", "Lxyz/xenondevs/nova/addon/simpleupgrades/UpgradeHolder;", "energyHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/DefaultEnergyHolder;", "itemHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/holder/DefaultItemHolder;", "energyPerTick", "", "getEnergyPerTick", "()J", "energyPerTick$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "progressPerTick", "", "getProgressPerTick", "()D", "progressPerTick$delegate", "maxIdleTime", "", "getMaxIdleTime", "()I", "maxIdleTime$delegate", "plantType", "Lorg/bukkit/Material;", "Lorg/jetbrains/annotations/NotNull;", "plant", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "growthProgress", "idleTimeLeft", "handleEnable", "", "handleDisable", "handleTick", "updatePlantEntity", "handleInputInventoryUpdate", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleOutputInventoryUpdate", "TreeFactoryMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nTreeFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFactory.kt\nxyz/xenondevs/nova/addon/machines/tileentity/agriculture/TreeFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class TreeFactory
extends NetworkedTileEntity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final VirtualInventory inputInventory;
    @NotNull
    private final VirtualInventory outputInventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final DefaultEnergyHolder energyHolder;
    @NotNull
    private final DefaultItemHolder itemHolder;
    @NotNull
    private final Provider energyPerTick$delegate;
    @NotNull
    private final Provider progressPerTick$delegate;
    @NotNull
    private final Provider maxIdleTime$delegate;
    @Nullable
    private Material plantType;
    @NotNull
    private final FakeItemDisplay plant;
    private double growthProgress;
    private int idleTimeLeft;

    public TreeFactory(@NotNull BlockPos pos, @NotNull NovaBlockState blockState, @NotNull Compound data) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(pos, blockState, data);
        Object[] objectArray = new int[]{1};
        this.inputInventory = TileEntity.storedInventory$default((TileEntity)((TileEntity)this), (String)"input", (int)1, (boolean)false, (int[])objectArray, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleInputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)32, null);
        this.outputInventory = TileEntity.storedInventory$default((TileEntity)((TileEntity)this), (String)"output", (int)9, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleOutputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        objectArray = new UpgradeType[3];
        objectArray[0] = (int)UpgradeTypes.INSTANCE.getSPEED();
        objectArray[1] = (int)UpgradeTypes.INSTANCE.getEFFICIENCY();
        objectArray[2] = (int)UpgradeTypes.INSTANCE.getENERGY();
        this.upgradeHolder = ExtensionsKt.storedUpgradeHolder((TileEntity)((TileEntity)this), (UpgradeType[])objectArray);
        this.energyHolder = ExtensionsKt.storedEnergyHolderBlockSide$default((NetworkedTileEntity)this, (Provider)TreeFactoryKt.access$getMAX_ENERGY$p(), (UpgradeHolder)this.upgradeHolder, (NetworkConnectionType)NetworkConnectionType.INSERT, (Set)TreeFactoryKt.access$getBLOCKED_SIDES$p(), null, (int)16, null);
        objectArray = new Pair[1];
        objectArray[0] = (int)TuplesKt.to((Object)this.inputInventory, (Object)NetworkConnectionType.INSERT);
        this.itemHolder = NetworkedTileEntity.storedItemHolderBlockSide$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.outputInventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])objectArray, (Set)TreeFactoryKt.access$getBLOCKED_SIDES$p(), null, null, (int)24, null);
        this.energyPerTick$delegate = TileEntityUtilsKt.energyConsumption((Provider<Long>)TreeFactoryKt.access$getENERGY_PER_TICK$p(), this.upgradeHolder);
        this.progressPerTick$delegate = TileEntityUtilsKt.speedMultipliedValueDouble((Provider<Double>)TreeFactoryKt.access$getPROGRESS_PER_TICK$p(), this.upgradeHolder);
        this.maxIdleTime$delegate = TileEntityUtilsKt.maxIdleTime((Provider<Integer>)TreeFactoryKt.access$getIDLE_TIME$p(), this.upgradeHolder);
        ItemStack itemStack = this.inputInventory.getItem(0);
        this.plantType = itemStack != null ? itemStack.getType() : null;
        Location location = pos.getLocation().add(0.5, 0.0625, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        this.plant = new FakeItemDisplay(location, false, TreeFactory::plant$lambda$0);
    }

    private final long getEnergyPerTick() {
        return ((Number)this.energyPerTick$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    private final double getProgressPerTick() {
        return ((Number)this.progressPerTick$delegate.getValue((Object)this, $$delegatedProperties[1])).doubleValue();
    }

    private final int getMaxIdleTime() {
        return ((Number)this.maxIdleTime$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    public void handleEnable() {
        super.handleEnable();
        this.plant.register();
    }

    public void handleDisable() {
        super.handleDisable();
        this.plant.remove();
    }

    public void handleTick() {
        if (this.energyHolder.getEnergy() >= this.getEnergyPerTick() && this.plantType != null) {
            Object v = TreeFactoryKt.access$getPLANTS$p().get(this.plantType);
            Intrinsics.checkNotNull(v);
            ItemStack plantLoot = ((PlantConfiguration)v).getLoot();
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.outputInventory.canHold(plantLoot, new ItemStack[0])) {
                return;
            }
            DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
            defaultEnergyHolder.setEnergy(defaultEnergyHolder.getEnergy() - this.getEnergyPerTick());
            if (this.idleTimeLeft == 0) {
                if (this.plantType != null) {
                    this.growthProgress += this.getProgressPerTick();
                    if (this.growthProgress >= 1.0) {
                        this.idleTimeLeft = this.getMaxIdleTime();
                    }
                    this.updatePlantEntity();
                }
            } else {
                int n = this.idleTimeLeft;
                this.idleTimeLeft = n + -1;
                ParticleType particleType = ParticleTypes.DUST;
                Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST");
                NMSUtilsKt.sendTo((Packet)((Packet)ParticleBuilderKt.particle((ParticleType)particleType, arg_0 -> TreeFactory.handleTick$lambda$1(this, arg_0))), (Iterable)this.getViewers());
                if (this.idleTimeLeft == 0) {
                    this.growthProgress = 0.0;
                    int leftover = this.outputInventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), plantLoot);
                    if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftover > 0) {
                        ItemStack itemStack;
                        ItemStack $this$handleTick_u24lambda_u242 = itemStack = plantLoot.clone();
                        boolean bl = false;
                        $this$handleTick_u24lambda_u242.setAmount(leftover);
                        ItemStack itemStack2 = itemStack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"apply(...)");
                        ItemStack remains = itemStack2;
                        Location location = this.getPos().getLocation().add(0.5, 0.5, 0.5);
                        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
                        Location dropLoc = location;
                        LocationUtilsKt.dropItem((Location)dropLoc, (ItemStack)remains);
                    }
                }
            }
        }
    }

    private final void updatePlantEntity() {
        float size = (float)((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.growthProgress), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)1.0)))).doubleValue();
        this.plant.updateEntityData(true, arg_0 -> TreeFactory.updatePlantEntity$lambda$4(this, size, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleInputInventoryUpdate(ItemPreUpdateEvent event) {
        if (event.getNewItem() != null) {
            Set set = TreeFactoryKt.access$getPLANTS$p().keySet();
            ItemStack itemStack = event.getNewItem();
            Intrinsics.checkNotNull((Object)itemStack);
            if (!set.contains(itemStack.getType())) {
                event.setCancelled(true);
                return;
            }
        }
        ItemStack itemStack = event.getNewItem();
        this.plantType = itemStack != null ? itemStack.getType() : null;
        this.growthProgress = 0.0;
        this.updatePlantEntity();
    }

    private final void handleOutputInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && !event.isRemove());
    }

    private static final Unit plant$lambda$0(FakeItemDisplay fakeItemDisplay, ItemDisplayMetadata meta) {
        Intrinsics.checkNotNullParameter((Object)fakeItemDisplay, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        meta.setTransformationInterpolationDuration(1);
        return Unit.INSTANCE;
    }

    private static final Unit handleTick$lambda$1(TreeFactory this$0, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        Object v = TreeFactoryKt.access$getPLANTS$p().get(this$0.plantType);
        Intrinsics.checkNotNull(v);
        ParticleBuilderKt.color((ParticleBuilder)$this$particle, (Color)((PlantConfiguration)v).getColor());
        Location location = this$0.getPos().getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        $this$particle.location(location);
        $this$particle.offset(0.15, 0.15, 0.15);
        $this$particle.speed(0.1f);
        $this$particle.amount(5);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updatePlantEntity$lambda$4(TreeFactory this$0, float $size, ItemDisplayMetadata $this$updateEntityData) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
        $this$updateEntityData.setTransformationInterpolationDelay(0);
        ItemDisplayMetadata itemDisplayMetadata = $this$updateEntityData;
        Material material = this$0.plantType;
        if (material != null) {
            void it;
            Material material2 = material;
            ItemDisplayMetadata itemDisplayMetadata2 = itemDisplayMetadata;
            boolean bl = false;
            Object v = TreeFactoryKt.access$getPLANTS$p().get(it);
            Intrinsics.checkNotNull(v);
            itemStack = ((PlantConfiguration)v).getMiniature().getClientsideProvider().get();
            itemDisplayMetadata = itemDisplayMetadata2;
        } else {
            itemStack = null;
        }
        itemDisplayMetadata.setItemStack(itemStack);
        $this$updateEntityData.setScale((Vector3fc)new Vector3f($size, $size, $size));
        $this$updateEntityData.setTranslation((Vector3fc)new Vector3f(0.0f, 0.5f * $size, 0.0f));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleInputInventoryUpdate(TreeFactory $this, ItemPreUpdateEvent event) {
        $this.handleInputInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleOutputInventoryUpdate(TreeFactory $this, ItemPreUpdateEvent event) {
        $this.handleOutputInventoryUpdate(event);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TreeFactory.class, "energyPerTick", "getEnergyPerTick()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TreeFactory.class, "progressPerTick", "getProgressPerTick()D", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TreeFactory.class, "maxIdleTime", "getMaxIdleTime()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @TileEntityMenuClass
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0083\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/agriculture/TreeFactory$TreeFactoryMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "<init>", "(Lxyz/xenondevs/nova/addon/machines/tileentity/agriculture/TreeFactory;)V", "sideConfigGui", "Lxyz/xenondevs/nova/ui/menu/sideconfig/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    private final class TreeFactoryMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public TreeFactoryMenu() {
            super((TileEntity)TreeFactory.this, null, 1, null);
            Gui gui2 = new Gui[]{TuplesKt.to((Object)TreeFactory.this.itemHolder.getNetworkedInventory(TreeFactory.this.inputInventory), (Object)"inventory.nova.input"), TuplesKt.to((Object)TreeFactory.this.itemHolder.getNetworkedInventory(TreeFactory.this.outputInventory), (Object)"inventory.nova.output")};
            this.sideConfigGui = SideConfigMenuKt.SideConfigMenuItem((NetworkEndPoint)((NetworkEndPoint)TreeFactory.this), (Map)MapsKt.mapOf((Pair[])gui2), (Function1)((Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((TreeFactoryMenu)((Object)this.receiver)).openWindow(p0);
                }
            }));
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s u # # # # e |", "| # # # o o o e |", "| # i # o o o e |", "| # # # o o o e |", "3 - - - - - - - 4"};
            Gui.Builder builder = Gui.builder().setStructure(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setStructure(...)");
            gui2 = ((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)StructureIngredientsKt.addIngredient((IngredientMapper)((IngredientMapper)builder), (char)'i', (Inventory)((Inventory)TreeFactory.this.inputInventory), (NovaItem)GuiItems.INSTANCE.getSAPLING_PLACEHOLDER())).addIngredient('o', (Inventory)TreeFactory.this.outputInventory)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(TreeFactory.this.upgradeHolder))).addIngredient('e', (Supplier)new EnergyBar(4, TreeFactory.this.energyHolder, null, 4, null))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

