/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.energy;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.registry.BlockStateProperties;
import xyz.xenondevs.nova.addon.machines.tileentity.energy.LavaGeneratorKt;
import xyz.xenondevs.nova.addon.simpleupgrades.ExtensionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeHolder;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeType;
import xyz.xenondevs.nova.addon.simpleupgrades.gui.OpenUpgradesItem;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.ui.menu.EnergyBar;
import xyz.xenondevs.nova.ui.menu.FluidBar;
import xyz.xenondevs.nova.ui.menu.sideconfig.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenu;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenuKt;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.PacketTask;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.property.BlockStateProperty;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.block.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.holder.DefaultEnergyHolder;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.FluidType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.container.FluidContainer;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.holder.DefaultFluidHolder;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.holder.FluidHolder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/energy/LavaGenerator;", "Lxyz/xenondevs/nova/world/block/tileentity/NetworkedTileEntity;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "data", "Lxyz/xenondevs/cbf/Compound;", "<init>", "(Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;Lxyz/xenondevs/cbf/Compound;)V", "upgradeHolder", "Lxyz/xenondevs/nova/addon/simpleupgrades/UpgradeHolder;", "fluidContainer", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/container/FluidContainer;", "fluidHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/holder/DefaultFluidHolder;", "energyHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/DefaultEnergyHolder;", "burnRate", "", "getBurnRate", "()D", "burnRate$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "energyPerTick", "", "getEnergyPerTick", "()J", "energyPerTick$delegate", "active", "", "setActive", "(Z)V", "burnProgress", "smokeParticleTask", "Lxyz/xenondevs/nova/util/PacketTask;", "lavaParticleTask", "handleDisable", "", "handleTick", "LavaGeneratorMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nLavaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavaGenerator.kt\nxyz/xenondevs/nova/addon/machines/tileentity/energy/LavaGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class LavaGenerator
extends NetworkedTileEntity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer fluidContainer;
    @NotNull
    private final DefaultFluidHolder fluidHolder;
    @NotNull
    private final DefaultEnergyHolder energyHolder;
    @NotNull
    private final Provider burnRate$delegate;
    @NotNull
    private final Provider energyPerTick$delegate;
    private boolean active;
    private double burnProgress;
    @NotNull
    private final PacketTask smokeParticleTask;
    @NotNull
    private final PacketTask lavaParticleTask;

    public LavaGenerator(@NotNull BlockPos pos, @NotNull NovaBlockState blockState, @NotNull Compound data) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(pos, blockState, data);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getFLUID()};
        this.upgradeHolder = ExtensionsKt.storedUpgradeHolder((TileEntity)((TileEntity)this), (UpgradeType[])upgradeTypeArray);
        this.fluidContainer = ExtensionsKt.storedFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.setOf((Object)FluidType.LAVA), (Provider)LavaGeneratorKt.access$getFLUID_CAPACITY$p(), (UpgradeHolder)this.upgradeHolder, (boolean)false, null, (int)48, null);
        this.fluidHolder = NetworkedTileEntity.storedFluidHolderBlockSide$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.fluidContainer, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], (Set)LavaGeneratorKt.access$getBLOCKED_SIDES$p(), null, null, (int)24, null);
        this.energyHolder = ExtensionsKt.storedEnergyHolderBlockSide$default((NetworkedTileEntity)this, (Provider)LavaGeneratorKt.access$getENERGY_CAPACITY$p(), (UpgradeHolder)this.upgradeHolder, (NetworkConnectionType)NetworkConnectionType.EXTRACT, (Set)LavaGeneratorKt.access$getBLOCKED_SIDES$p(), null, (int)16, null);
        this.burnRate$delegate = Providers.combinedProvider((Provider)LavaGeneratorKt.access$getBURN_RATE$p(), (Provider)this.upgradeHolder.getValueProvider(UpgradeTypes.INSTANCE.getSPEED()), (Provider)this.upgradeHolder.getValueProvider(UpgradeTypes.INSTANCE.getEFFICIENCY()), LavaGenerator::burnRate_delegate$lambda$0);
        this.energyPerTick$delegate = Providers.combinedProvider((Provider)LavaGeneratorKt.access$getENERGY_PER_MB$p(), (Provider)LavaGeneratorKt.access$getBURN_RATE$p(), (Provider)this.upgradeHolder.getValueProvider(UpgradeTypes.INSTANCE.getSPEED()), LavaGenerator::energyPerTick_delegate$lambda$1);
        this.active = (Boolean)blockState.getOrThrow((BlockStateProperty)BlockStateProperties.INSTANCE.getACTIVE());
        SimpleParticleType simpleParticleType = ParticleTypes.SMOKE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SMOKE");
        this.smokeParticleTask = new PacketTask(CollectionsKt.listOf((Object)ParticleBuilderKt.particle((ParticleType)((ParticleType)simpleParticleType), arg_0 -> LavaGenerator.smokeParticleTask$lambda$2(blockState, pos, arg_0))), 3L, (Function0)new Function0<List<? extends Player>>((Object)this){

            public final List<Player> invoke() {
                return ((LavaGenerator)((Object)this.receiver)).getViewers();
            }
        });
        SimpleParticleType simpleParticleType2 = ParticleTypes.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType2, (String)"LAVA");
        this.lavaParticleTask = new PacketTask(CollectionsKt.listOf((Object)ParticleBuilderKt.particle((ParticleType)((ParticleType)simpleParticleType2), arg_0 -> LavaGenerator.lavaParticleTask$lambda$4(blockState, pos, arg_0))), 200L, (Function0)new Function0<List<? extends Player>>((Object)this){

            public final List<Player> invoke() {
                return ((LavaGenerator)((Object)this.receiver)).getViewers();
            }
        });
    }

    private final double getBurnRate() {
        return ((Number)this.burnRate$delegate.getValue((Object)this, $$delegatedProperties[0])).doubleValue();
    }

    private final long getEnergyPerTick() {
        return ((Number)this.energyPerTick$delegate.getValue((Object)this, $$delegatedProperties[1])).longValue();
    }

    private final void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.updateBlockState(this.getBlockState().with((BlockStateProperty)BlockStateProperties.INSTANCE.getACTIVE(), (Object)active));
        }
    }

    public void handleDisable() {
        super.handleDisable();
        this.smokeParticleTask.stop();
        this.lavaParticleTask.stop();
    }

    public void handleTick() {
        long lavaAmount;
        if (this.energyHolder.getEnergy() == this.energyHolder.getMaxEnergy() || this.fluidContainer.isEmpty()) {
            if (this.active) {
                this.setActive(false);
                this.smokeParticleTask.stop();
                this.lavaParticleTask.stop();
            }
            return;
        }
        if (!this.active) {
            this.setActive(true);
            this.smokeParticleTask.start();
            this.lavaParticleTask.start();
        }
        if ((double)(lavaAmount = this.fluidContainer.getAmount()) >= this.getBurnRate()) {
            DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
            defaultEnergyHolder.setEnergy(defaultEnergyHolder.getEnergy() + this.getEnergyPerTick());
            this.burnProgress += this.getBurnRate();
            if (this.burnProgress > 1.0) {
                long burnt = (long)this.burnProgress;
                this.burnProgress -= (double)burnt;
                this.fluidContainer.takeFluid(burnt);
            }
        } else {
            DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
            long l = defaultEnergyHolder.getEnergy();
            double d = lavaAmount;
            Object object = LavaGeneratorKt.access$getENERGY_PER_MB$p().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            defaultEnergyHolder.setEnergy(l + (long)(d * ((Number)object).doubleValue()));
            this.fluidContainer.clear();
        }
    }

    private static final double burnRate_delegate$lambda$0(double burnRate, double speed, double efficiency) {
        return burnRate * speed / efficiency;
    }

    private static final long energyPerTick_delegate$lambda$1(double energyPerMb, double burnRate, double speed) {
        return MathKt.roundToLong((double)(energyPerMb * burnRate * speed));
    }

    private static final Unit smokeParticleTask$lambda$2(NovaBlockState $blockState, BlockPos $pos, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        BlockFace facing = (BlockFace)$blockState.getOrThrow((BlockStateProperty)DefaultBlockStateProperties.INSTANCE.getFACING());
        Location location = $pos.getLocation().add(0.5, 0.6, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        $this$particle.location(LocationUtilsKt.advance((Location)location, (BlockFace)facing, (double)0.6));
        Axis axis = BlockFaceUtilsKt.getAxis((BlockFace)BlockSide.RIGHT.getBlockFace(facing));
        Intrinsics.checkNotNull((Object)axis);
        $this$particle.offset(axis, 0.15f);
        $this$particle.offsetY(0.1f);
        $this$particle.speed(0.0f);
        $this$particle.amount(1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lavaParticleTask$lambda$4(NovaBlockState $blockState, BlockPos $pos, ParticleBuilder $this$particle) {
        void $this$lavaParticleTask_u24lambda_u244_u24lambda_u243;
        Location location;
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        BlockFace facing = (BlockFace)$blockState.getOrThrow((BlockStateProperty)DefaultBlockStateProperties.INSTANCE.getFACING());
        Location location2 = location = LocationUtilsKt.advance((Location)$pos.getLocation(), (BlockFace)facing, (double)0.6);
        ParticleBuilder particleBuilder = $this$particle;
        boolean bl = false;
        $this$lavaParticleTask_u24lambda_u244_u24lambda_u243.setY($this$lavaParticleTask_u24lambda_u244_u24lambda_u243.getY() + 0.6);
        particleBuilder.location(location);
        Axis axis = BlockFaceUtilsKt.getAxis((BlockFace)BlockSide.RIGHT.getBlockFace(facing));
        Intrinsics.checkNotNull((Object)axis);
        $this$particle.offset(axis, 0.15f);
        $this$particle.offsetY(0.1f);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LavaGenerator.class, "burnRate", "getBurnRate()D", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LavaGenerator.class, "energyPerTick", "getEnergyPerTick()J", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @TileEntityMenuClass
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/energy/LavaGenerator$LavaGeneratorMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "<init>", "(Lxyz/xenondevs/nova/addon/machines/tileentity/energy/LavaGenerator;)V", "sideConfigGui", "Lxyz/xenondevs/nova/ui/menu/sideconfig/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class LavaGeneratorMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public LavaGeneratorMenu() {
            super((TileEntity)LavaGenerator.this, null, 1, null);
            this.sideConfigGui = SideConfigMenuKt.SideConfigMenuFluid((NetworkEndPoint)((NetworkEndPoint)LavaGenerator.this), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)LavaGenerator.this.fluidContainer, (Object)"container.nova.lava_tank")), (Function1)((Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((LavaGeneratorMenu)((Object)this.receiver)).openWindow(p0);
                }
            }));
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # # f e |", "| u # # # # f e |", "| # # # # # f e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)Gui.builder().setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(LavaGenerator.this.upgradeHolder))).addIngredient('e', (Supplier)new EnergyBar(3, LavaGenerator.this.energyHolder, null, 4, null))).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)LavaGenerator.this.fluidHolder, LavaGenerator.this.fluidContainer, null, 8, null))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

