/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.energy;

import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.tileentity.energy.SolarPanelKt;
import xyz.xenondevs.nova.addon.machines.util.TileEntityUtilsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.ExtensionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeHolder;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeType;
import xyz.xenondevs.nova.addon.simpleupgrades.gui.OpenUpgradesItem;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.ui.menu.EnergyBar;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.holder.DefaultEnergyHolder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/energy/SolarPanel;", "Lxyz/xenondevs/nova/world/block/tileentity/NetworkedTileEntity;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "data", "Lxyz/xenondevs/cbf/Compound;", "<init>", "(Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;Lxyz/xenondevs/cbf/Compound;)V", "upgradeHolder", "Lxyz/xenondevs/nova/addon/simpleupgrades/UpgradeHolder;", "energyHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/DefaultEnergyHolder;", "peakEnergyOutput", "", "getPeakEnergyOutput", "()J", "peakEnergyOutput$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "obstructionTask", "Lorg/bukkit/scheduler/BukkitTask;", "obstructed", "", "handleEnable", "", "handleDisable", "checkSkyObstruction", "handleTick", "calculateCurrentEnergyOutput", "SolarPanelMenu", "machines"})
public final class SolarPanel
extends NetworkedTileEntity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final DefaultEnergyHolder energyHolder;
    @NotNull
    private final Provider peakEnergyOutput$delegate;
    private BukkitTask obstructionTask;
    private boolean obstructed;

    public SolarPanel(@NotNull BlockPos pos, @NotNull NovaBlockState blockState, @NotNull Compound data) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(pos, blockState, data);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY()};
        this.upgradeHolder = ExtensionsKt.storedUpgradeHolder((TileEntity)((TileEntity)this), (UpgradeType[])upgradeTypeArray);
        this.energyHolder = ExtensionsKt.storedEnergyHolderBlockFace$default((NetworkedTileEntity)this, (Provider)SolarPanelKt.access$getMAX_ENERGY$p(), (UpgradeHolder)this.upgradeHolder, (NetworkConnectionType)NetworkConnectionType.EXTRACT, (Set)SolarPanelKt.access$getBLOCKED_FACES$p(), null, (int)16, null);
        this.peakEnergyOutput$delegate = TileEntityUtilsKt.efficiencyMultipliedValue((Provider<Long>)SolarPanelKt.access$getENERGY_PER_TICK$p(), this.upgradeHolder);
        this.obstructed = true;
    }

    private final long getPeakEnergyOutput() {
        return ((Number)this.peakEnergyOutput$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    public void handleEnable() {
        super.handleEnable();
        this.obstructionTask = SchedulerUtilsKt.runTaskTimer((long)0L, (long)100L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                SolarPanel.access$checkSkyObstruction((SolarPanel)((Object)this.receiver));
            }
        }));
    }

    public void handleDisable() {
        super.handleDisable();
        BukkitTask bukkitTask = this.obstructionTask;
        if (bukkitTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"obstructionTask");
            bukkitTask = null;
        }
        bukkitTask.cancel();
    }

    private final void checkSkyObstruction() {
        this.obstructed = false;
        LocationUtilsKt.untilHeightLimit((Location)this.getPos().getLocation(), (boolean)false, arg_0 -> SolarPanel.checkSkyObstruction$lambda$0(this, arg_0));
    }

    public void handleTick() {
        DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
        defaultEnergyHolder.setEnergy(defaultEnergyHolder.getEnergy() + this.calculateCurrentEnergyOutput());
    }

    private final long calculateCurrentEnergyOutput() {
        long time = this.getPos().getWorld().getTime();
        if (!this.obstructed && time < 13000L) {
            int bestTime = 6500;
            double multiplier = (double)((long)bestTime - Math.abs((long)bestTime - time)) / (double)bestTime;
            return MathKt.roundToLong((double)((double)this.getPeakEnergyOutput() * multiplier));
        }
        return 0L;
    }

    private static final boolean checkSkyObstruction$lambda$0(SolarPanel this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Material material = it.getBlock().getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material material2 = material;
        if (material2 != Material.AIR && !MaterialUtilsKt.isGlass((Material)material2)) {
            this$0.obstructed = true;
            return false;
        }
        return true;
    }

    public static final /* synthetic */ void access$checkSkyObstruction(SolarPanel $this) {
        $this.checkSkyObstruction();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SolarPanel.class, "peakEnergyOutput", "getPeakEnergyOutput()J", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @TileEntityMenuClass
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/energy/SolarPanel$SolarPanelMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "<init>", "(Lxyz/xenondevs/nova/addon/machines/tileentity/energy/SolarPanel;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class SolarPanelMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final Gui gui;

        public SolarPanelMenu() {
            super((TileEntity)SolarPanel.this, null, 1, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| u # # e # # # |", "| # # # e # # # |", "| # # # e # # # |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder)((Gui.Builder)Gui.builder().setStructure(stringArray).addIngredient('u', (Item)new OpenUpgradesItem(SolarPanel.this.upgradeHolder))).addIngredient('e', (Supplier)new EnergyBar(3, SolarPanel.this.energyHolder, null, 4, null))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

