/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.tileentity.world.SprinklerKt;
import xyz.xenondevs.nova.addon.machines.util.TileEntityUtilsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.ExtensionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeHolder;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeType;
import xyz.xenondevs.nova.addon.simpleupgrades.gui.OpenUpgradesItem;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.ui.menu.FluidBar;
import xyz.xenondevs.nova.ui.menu.sideconfig.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenu;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenuKt;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.FluidType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.container.FluidContainer;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.holder.DefaultFluidHolder;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.world.region.DynamicRegion;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.VisualRegion;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;", "Lxyz/xenondevs/nova/world/block/tileentity/NetworkedTileEntity;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "data", "Lxyz/xenondevs/cbf/Compound;", "<init>", "(Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;Lxyz/xenondevs/cbf/Compound;)V", "upgradeHolder", "Lxyz/xenondevs/nova/addon/simpleupgrades/UpgradeHolder;", "tank", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/container/FluidContainer;", "fluidHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/holder/DefaultFluidHolder;", "waterPerMoistureLevel", "", "getWaterPerMoistureLevel", "()J", "waterPerMoistureLevel$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "region", "Lxyz/xenondevs/nova/world/region/DynamicRegion;", "handleEnable", "", "handleDisable", "SprinklerMenu", "Companion", "machines"})
public final class Sprinkler
extends NetworkedTileEntity {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer tank;
    @NotNull
    private final DefaultFluidHolder fluidHolder;
    @NotNull
    private final Provider waterPerMoistureLevel$delegate;
    @NotNull
    private final DynamicRegion region;
    @NotNull
    private static final ArrayList<Sprinkler> sprinklers;

    public Sprinkler(@NotNull BlockPos pos, @NotNull NovaBlockState blockState, @NotNull Compound data) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(pos, blockState, data);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getFLUID(), UpgradeTypes.INSTANCE.getRANGE()};
        this.upgradeHolder = ExtensionsKt.storedUpgradeHolder((TileEntity)((TileEntity)this), (UpgradeType[])upgradeTypeArray);
        this.tank = ExtensionsKt.storedFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.setOf((Object)FluidType.WATER), (Provider)SprinklerKt.access$getWATER_CAPACITY$p(), (UpgradeHolder)this.upgradeHolder, (boolean)false, null, (int)48, null);
        this.fluidHolder = NetworkedTileEntity.storedFluidHolderBlockFace$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.tank, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], (Set)SprinklerKt.access$getBLOCKED_FACES$p(), null, null, (int)24, null);
        this.waterPerMoistureLevel$delegate = TileEntityUtilsKt.efficiencyDividedValue((Provider<Long>)SprinklerKt.access$getWATER_PER_MOISTURE_LEVEL$p(), this.upgradeHolder);
        this.region = ExtensionsKt.storedRegion((TileEntity)((TileEntity)this), (String)"region.default", (Provider)SprinklerKt.access$getMIN_RANGE$p(), (Provider)SprinklerKt.access$getMAX_RANGE$p(), (int)SprinklerKt.access$getDEFAULT_RANGE(), (UpgradeHolder)this.upgradeHolder, arg_0 -> Sprinkler.region$lambda$0(pos, arg_0));
    }

    private final long getWaterPerMoistureLevel() {
        return ((Number)this.waterPerMoistureLevel$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    public void handleEnable() {
        super.handleEnable();
        ((Collection)sprinklers).add(this);
    }

    public void handleDisable() {
        super.handleDisable();
        ((Collection)sprinklers).remove((Object)this);
        VisualRegion.INSTANCE.removeRegion(this.getUuid());
    }

    private static final Region region$lambda$0(BlockPos $pos, int it) {
        double d = (double)it + 0.5;
        Location location = $pos.getLocation().add(-d + 0.5, -0.5, -d + 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location location2 = $pos.getLocation().add(d + 0.5, 0.5, d + 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        return new Region(location, location2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Sprinkler.class, "waterPerMoistureLevel", "getWaterPerMoistureLevel()J", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        sprinklers = new ArrayList();
        EventUtilsKt.registerEvents((Listener)Companion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$Companion;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "sprinklers", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;", "Lkotlin/collections/ArrayList;", "handleBlockPhysics", "", "event", "Lorg/bukkit/event/block/BlockPhysicsEvent;", "showWaterParticles", "block", "Lorg/bukkit/block/Block;", "players", "", "Lorg/bukkit/entity/Player;", "machines"})
    @SourceDebugExtension(value={"SMAP\nSprinkler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sprinkler.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
    public static final class Companion
    implements Listener {
        private Companion() {
        }

        @EventHandler
        public final void handleBlockPhysics(@NotNull BlockPhysicsEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getChangedType() == Material.FARMLAND && Intrinsics.areEqual((Object)event.getBlock(), (Object)event.getSourceBlock())) {
                Block block = event.getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
                Block block2 = block;
                Location location = block2.getLocation().add(0.5, 0.5, 0.5);
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
                Location location2 = location;
                BlockData blockData = block2.getBlockData();
                Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.type.Farmland");
                Farmland farmland = (Farmland)blockData;
                if (farmland.getMoisture() >= farmland.getMaximumMoisture()) {
                    return;
                }
                int requiredMoisture = farmland.getMaximumMoisture() - farmland.getMoisture();
                int addedMoisture = 0;
                Iterator iterator = sprinklers.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Sprinkler sprinkler = (Sprinkler)((Object)e);
                    if (!sprinkler.region.contains(location2)) continue;
                    int moistureFromSprinkler = Math.min(requiredMoisture - addedMoisture, (int)(sprinkler.tank.getAmount() / sprinkler.getWaterPerMoistureLevel()));
                    sprinkler.tank.takeFluid((long)moistureFromSprinkler * sprinkler.getWaterPerMoistureLevel());
                    if ((addedMoisture += moistureFromSprinkler) != requiredMoisture) continue;
                }
                if (addedMoisture > 0) {
                    farmland.setMoisture(farmland.getMoisture() + addedMoisture);
                    block2.setBlockData((BlockData)farmland, false);
                    this.showWaterParticles(block2, ((Sprinkler)((Object)sprinklers.get(0))).getViewers());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void showWaterParticles(Block block, List<? extends Player> players) {
            void $this$showWaterParticles_u24lambda_u240;
            Location location;
            SimpleParticleType simpleParticleType = ParticleTypes.SPLASH;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SPLASH");
            Location location2 = location = block.getLocation();
            ParticleType particleType = (ParticleType)simpleParticleType;
            boolean bl = false;
            $this$showWaterParticles_u24lambda_u240.add(0.5, 1.0, 0.5);
            Location location3 = location;
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"apply(...)");
            NMSUtilsKt.sendTo((Packet)((Packet)ParticleBuilderKt.particle((ParticleType)particleType, (Location)location3, Companion::showWaterParticles$lambda$1)), (Iterable)players);
        }

        private static final Unit showWaterParticles$lambda$1(ParticleBuilder $this$particle) {
            Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
            $this$particle.offset(0.2, 0.1, 0.2);
            $this$particle.speed(1.0f);
            $this$particle.amount(20);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @TileEntityMenuClass
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$SprinklerMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity$IndividualTileEntityMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;Lorg/bukkit/entity/Player;)V", "sideConfigGui", "Lxyz/xenondevs/nova/ui/menu/sideconfig/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class SprinklerMenu
    extends TileEntity.IndividualTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public SprinklerMenu(Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            super((TileEntity)Sprinkler.this, player, null, 2, null);
            this.sideConfigGui = SideConfigMenuKt.SideConfigMenuFluid((NetworkEndPoint)((NetworkEndPoint)Sprinkler.this), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Sprinkler.this.tank, (Object)"container.nova.fluid_tank")), (Function0)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((SprinklerMenu)((Object)this.receiver)).openWindow();
                }
            }));
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # f # # p |", "| u # # f # # d |", "| v # # f # # m |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)Gui.builder().setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(Sprinkler.this.upgradeHolder))).addIngredient('v', Sprinkler.this.region.getVisualizeRegionItem())).addIngredient('p', Sprinkler.this.region.getIncreaseSizeItem())).addIngredient('m', Sprinkler.this.region.getDecreaseSizeItem())).addIngredient('d', Sprinkler.this.region.getDisplaySizeItem())).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)Sprinkler.this.fluidHolder, Sprinkler.this.tank, null, 8, null))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

