/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.world;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EquipmentSlot;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.MutableProvider;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.gui.IdleBar;
import xyz.xenondevs.nova.addon.machines.registry.Items;
import xyz.xenondevs.nova.addon.machines.registry.Models;
import xyz.xenondevs.nova.addon.machines.tileentity.world.StarCollectorKt;
import xyz.xenondevs.nova.addon.machines.util.TileEntityUtilsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.ExtensionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeHolder;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeType;
import xyz.xenondevs.nova.addon.simpleupgrades.gui.OpenUpgradesItem;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.config.GlobalValues;
import xyz.xenondevs.nova.ui.menu.EnergyBar;
import xyz.xenondevs.nova.ui.menu.sideconfig.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenu;
import xyz.xenondevs.nova.ui.menu.sideconfig.SideConfigMenuKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.PacketTask;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.holder.DefaultEnergyHolder;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.holder.DefaultItemHolder;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeArmorStand;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ArmorStandMetadata;
import xyz.xenondevs.nova.world.item.NovaItem;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001HB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020>H\u0016J\b\u0010@\u001a\u00020>H\u0016J\b\u0010A\u001a\u00020>H\u0002J\b\u0010B\u001a\u00020>H\u0002J\b\u0010C\u001a\u00020>H\u0002J\b\u0010D\u001a\u00020>H\u0002J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020GH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b!\u0010\"*\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b&\u0010\"*\u0004\b%\u0010 R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010*\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010.*\u0004\b+\u0010 R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u00100\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010.*\u0004\b1\u0010 R\u000e\u00104\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u00106\u001a\u000707\u00a2\u0006\u0002\b8X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector;", "Lxyz/xenondevs/nova/world/block/tileentity/NetworkedTileEntity;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "data", "Lxyz/xenondevs/cbf/Compound;", "<init>", "(Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;Lxyz/xenondevs/cbf/Compound;)V", "inventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "upgradeHolder", "Lxyz/xenondevs/nova/addon/simpleupgrades/UpgradeHolder;", "itemHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/holder/DefaultItemHolder;", "energyHolder", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/DefaultEnergyHolder;", "idleEnergyPerTick", "", "getIdleEnergyPerTick", "()J", "idleEnergyPerTick$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "collectingEnergyPerTick", "getCollectingEnergyPerTick", "collectingEnergyPerTick$delegate", "maxIdleTimeProvider", "Lxyz/xenondevs/commons/provider/Provider;", "", "mxIdleTime", "getMxIdleTime$delegate", "(Lxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector;)Ljava/lang/Object;", "getMxIdleTime", "()I", "maxCollectionTimeProvider", "maxCollectionTime", "getMaxCollectionTime$delegate", "getMaxCollectionTime", "timeSpentIdleProvider", "Lxyz/xenondevs/commons/provider/MutableProvider;", "<set-?>", "timeSpentIdle", "getTimeSpentIdle$delegate", "getTimeSpentIdle", "setTimeSpentIdle", "(I)V", "timeSpentCollectingProvider", "timeSpentCollecting", "getTimeSpentCollecting$delegate", "getTimeSpentCollecting", "setTimeSpentCollecting", "particleVector", "Lorg/bukkit/util/Vector;", "rodLocation", "Lorg/bukkit/Location;", "Lorg/jetbrains/annotations/NotNull;", "rod", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeArmorStand;", "particleTask", "Lxyz/xenondevs/nova/util/PacketTask;", "handleEnable", "", "handleDisable", "handleTick", "handleNightTick", "handleCollectionTick", "handleIdleTick", "handleDayTick", "handleInventoryUpdate", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "StarCollectorMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nStarCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarCollector.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,214:1\n1923#2,14:215\n*S KotlinDebug\n*F\n+ 1 StarCollector.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector\n*L\n170#1:215,14\n*E\n"})
public final class StarCollector
extends NetworkedTileEntity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final DefaultItemHolder itemHolder;
    @NotNull
    private final DefaultEnergyHolder energyHolder;
    @NotNull
    private final Provider idleEnergyPerTick$delegate;
    @NotNull
    private final Provider collectingEnergyPerTick$delegate;
    @NotNull
    private final Provider<Integer> maxIdleTimeProvider;
    @NotNull
    private final Provider<Integer> maxCollectionTimeProvider;
    @NotNull
    private final MutableProvider<Integer> timeSpentIdleProvider;
    @NotNull
    private final MutableProvider<Integer> timeSpentCollectingProvider;
    private Vector particleVector;
    @NotNull
    private final Location rodLocation;
    @NotNull
    private final FakeArmorStand rod;
    @NotNull
    private final PacketTask particleTask;

    public StarCollector(@NotNull BlockPos pos, @NotNull NovaBlockState blockState, @NotNull Compound data) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(pos, blockState, data);
        this.inventory = TileEntity.storedInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)1, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                StarCollector.access$handleInventoryUpdate((StarCollector)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY()};
        this.upgradeHolder = ExtensionsKt.storedUpgradeHolder((TileEntity)((TileEntity)this), (UpgradeType[])upgradeTypeArray);
        this.itemHolder = NetworkedTileEntity.storedItemHolderBlockFace$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], (Set)StarCollectorKt.access$getBLOCKED_FACES$p(), null, null, (int)24, null);
        this.energyHolder = ExtensionsKt.storedEnergyHolderBlockFace$default((NetworkedTileEntity)this, (Provider)StarCollectorKt.access$getMAX_ENERGY$p(), (UpgradeHolder)this.upgradeHolder, (NetworkConnectionType)NetworkConnectionType.INSERT, (Set)StarCollectorKt.access$getBLOCKED_FACES$p(), null, (int)16, null);
        this.idleEnergyPerTick$delegate = TileEntityUtilsKt.energyConsumption((Provider<Long>)StarCollectorKt.access$getIDLE_ENERGY_PER_TICK$p(), this.upgradeHolder);
        this.collectingEnergyPerTick$delegate = TileEntityUtilsKt.energyConsumption((Provider<Long>)StarCollectorKt.access$getCOLLECTING_ENERGY_PER_TICK$p(), this.upgradeHolder);
        this.maxIdleTimeProvider = TileEntityUtilsKt.maxIdleTime((Provider<Integer>)StarCollectorKt.access$getIDLE_TIME$p(), this.upgradeHolder);
        this.maxCollectionTimeProvider = TileEntityUtilsKt.maxIdleTime((Provider<Integer>)StarCollectorKt.access$getCOLLECTION_TIME$p(), this.upgradeHolder);
        this.timeSpentIdleProvider = Providers.mutableProvider((Object)0);
        this.timeSpentCollectingProvider = Providers.mutableProvider((Object)-1);
        Location location = pos.getLocation().add(0.5, 0.7, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        this.rodLocation = location;
        Location location2 = pos.getLocation().add(0.5, -1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        this.rod = new FakeArmorStand(location2, false, StarCollector::rod$lambda$0);
        ParticleType particleType = ParticleTypes.DUST_COLOR_TRANSITION;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST_COLOR_TRANSITION");
        this.particleTask = new PacketTask(CollectionsKt.listOf((Object)ParticleBuilderKt.particle((ParticleType)particleType, arg_0 -> StarCollector.particleTask$lambda$1(pos, arg_0))), 1L, (Function0)new Function0<List<? extends Player>>((Object)this){

            public final List<Player> invoke() {
                return ((StarCollector)((Object)this.receiver)).getViewers();
            }
        });
    }

    private final long getIdleEnergyPerTick() {
        return ((Number)this.idleEnergyPerTick$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    private final long getCollectingEnergyPerTick() {
        return ((Number)this.collectingEnergyPerTick$delegate.getValue((Object)this, $$delegatedProperties[1])).longValue();
    }

    private final int getMxIdleTime() {
        return ((Number)this.maxIdleTimeProvider.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    private static Object getMxIdleTime$delegate(StarCollector starCollector) {
        return starCollector.maxIdleTimeProvider;
    }

    private final int getMaxCollectionTime() {
        return ((Number)this.maxCollectionTimeProvider.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    private static Object getMaxCollectionTime$delegate(StarCollector starCollector) {
        return starCollector.maxCollectionTimeProvider;
    }

    private final int getTimeSpentIdle() {
        return ((Number)this.timeSpentIdleProvider.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    private final void setTimeSpentIdle(int n) {
        this.timeSpentIdleProvider.setValue((Object)this, $$delegatedProperties[4], (Object)n);
    }

    private static Object getTimeSpentIdle$delegate(StarCollector starCollector) {
        return starCollector.timeSpentIdleProvider;
    }

    private final int getTimeSpentCollecting() {
        return ((Number)this.timeSpentCollectingProvider.getValue((Object)this, $$delegatedProperties[5])).intValue();
    }

    private final void setTimeSpentCollecting(int n) {
        this.timeSpentCollectingProvider.setValue((Object)this, $$delegatedProperties[5], (Object)n);
    }

    private static Object getTimeSpentCollecting$delegate(StarCollector starCollector) {
        return starCollector.timeSpentCollectingProvider;
    }

    public void handleEnable() {
        super.handleEnable();
        this.rod.register();
        this.particleTask.start();
    }

    public void handleDisable() {
        super.handleDisable();
        this.rod.remove();
        this.particleTask.stop();
    }

    public void handleTick() {
        long l = this.getPos().getWorld().getTime();
        boolean bl = 13000L <= l ? l < 23001L : false;
        if (bl || this.getTimeSpentCollecting() != -1) {
            this.handleNightTick();
        } else {
            this.handleDayTick();
        }
    }

    private final void handleNightTick() {
        if (this.getTimeSpentCollecting() != -1) {
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && this.inventory.isFull()) {
                return;
            }
            if (this.energyHolder.getEnergy() >= this.getCollectingEnergyPerTick()) {
                DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
                defaultEnergyHolder.setEnergy(defaultEnergyHolder.getEnergy() - this.getCollectingEnergyPerTick());
                this.handleCollectionTick();
            }
        } else if (this.energyHolder.getEnergy() >= this.getIdleEnergyPerTick()) {
            DefaultEnergyHolder defaultEnergyHolder = this.energyHolder;
            defaultEnergyHolder.setEnergy(defaultEnergyHolder.getEnergy() - this.getIdleEnergyPerTick());
            this.handleIdleTick();
        }
    }

    private final void handleCollectionTick() {
        int n = this.getTimeSpentCollecting();
        this.setTimeSpentCollecting(n + 1);
        if (this.getTimeSpentCollecting() >= this.getMaxCollectionTime()) {
            this.setTimeSpentIdle(0);
            this.setTimeSpentCollecting(-1);
            ItemStack item = NovaItem.createItemStack$default((NovaItem)Items.INSTANCE.getSTAR_DUST(), (int)0, (int)1, null);
            int leftOver = this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), item);
            if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftOver != 0) {
                LocationUtilsKt.dropItem((Location)this.getPos().getLocation(), (ItemStack)item);
            }
            this.particleTask.stop();
            this.rod.setEquipment(EquipmentSlot.HEAD, Models.INSTANCE.getSTAR_COLLECTOR_ROD_OFF().getClientsideProvider().get(), true);
        } else {
            double percentageCollected = (double)(this.getMaxCollectionTime() - this.getTimeSpentCollecting()) / (double)this.getMaxCollectionTime();
            double particleDistance = percentageCollected * (0.75 * (double)this.getMaxCollectionTime());
            Location location = this.rodLocation.clone();
            Vector vector = this.particleVector;
            if (vector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"particleVector");
                vector = null;
            }
            Location location2 = location.add(vector.clone().multiply(particleDistance));
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
            Location particleLocation = location2;
            ParticleType particleType = ParticleTypes.DUST;
            Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST");
            NMSUtilsKt.sendTo((Packet)((Packet)ParticleBuilderKt.particle((ParticleType)particleType, arg_0 -> StarCollector.handleCollectionTick$lambda$2(particleLocation, arg_0))), (Iterable)this.getViewers());
        }
    }

    private final void handleIdleTick() {
        int n = this.getTimeSpentIdle();
        this.setTimeSpentIdle(n + 1);
        if (this.getTimeSpentIdle() >= this.getMxIdleTime()) {
            this.setTimeSpentCollecting(0);
            this.particleTask.start();
            this.rod.setEquipment(EquipmentSlot.HEAD, Models.INSTANCE.getSTAR_COLLECTOR_ROD_ON().getClientsideProvider().get(), true);
            this.rodLocation.setYaw(this.rod.getLocation().getYaw());
            this.particleVector = LocationUtilsKt.Vector((float)this.rod.getLocation().getYaw(), (float)-65.0f);
        } else {
            this.rod.teleport(StarCollector::handleIdleTick$lambda$3);
        }
    }

    private final void handleDayTick() {
        double distance;
        Object v1;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Sequence $this$minByOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> StarCollector.handleDayTick$lambda$4(this, arg_0));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Player it = (Player)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getLocation().distanceSquared(this.rodLocation);
                do {
                    Object e$iv = iterator$iv.next();
                    Player it2 = (Player)e$iv;
                    $i$a$-minByOrNull-StarCollector$handleDayTick$player$2 = false;
                    double v$iv = it2.getLocation().distanceSquared(this.rodLocation);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Player player = v1;
        if (player != null && (distance = this.rodLocation.distance(player.getLocation())) <= 5.0) {
            Vector vector = player.getLocation().subtract(this.rodLocation).toVector();
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"toVector(...)");
            Vector vector2 = vector;
            float yaw = LocationUtilsKt.calculateYaw((Vector)vector2);
            this.rod.teleport(arg_0 -> StarCollector.handleDayTick$lambda$6(yaw, arg_0));
        }
    }

    private final void handleInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && !event.isRemove());
    }

    private static final Unit rod$lambda$0(FakeArmorStand ast, ArmorStandMetadata data) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.setMarker(true);
        data.setInvisible(true);
        ast.setEquipment(EquipmentSlot.HEAD, Models.INSTANCE.getSTAR_COLLECTOR_ROD_OFF().getClientsideProvider().get(), false);
        return Unit.INSTANCE;
    }

    private static final Unit particleTask$lambda$1(BlockPos $pos, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        Location location = $pos.getLocation().add(0.5, 0.2, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        $this$particle.location(location);
        ParticleBuilderKt.dustTransition((ParticleBuilder)$this$particle, (Color)new Color(132, 0, 245), (Color)new Color(196, 128, 217), (float)1.0f);
        $this$particle.offset(0.25, 0.1, 0.25);
        $this$particle.amount(3);
        return Unit.INSTANCE;
    }

    private static final Unit handleCollectionTick$lambda$2(Location $particleLocation, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        $this$particle.location($particleLocation);
        ParticleBuilderKt.color((ParticleBuilder)$this$particle, (Color)new Color(255, 255, 255));
        return Unit.INSTANCE;
    }

    private static final Unit handleIdleTick$lambda$3(Location $this$teleport) {
        Intrinsics.checkNotNullParameter((Object)$this$teleport, (String)"$this$teleport");
        $this$teleport.setYaw($this$teleport.getYaw() + 2.0f);
        return Unit.INSTANCE;
    }

    private static final boolean handleDayTick$lambda$4(StarCollector this$0, Player it) {
        return Intrinsics.areEqual((Object)it.getLocation().getWorld(), (Object)this$0.getPos().getWorld());
    }

    private static final Unit handleDayTick$lambda$6(float $yaw, Location $this$teleport) {
        Intrinsics.checkNotNullParameter((Object)$this$teleport, (String)"$this$teleport");
        $this$teleport.setYaw($yaw);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(StarCollector $this, ItemPreUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StarCollector.class, "idleEnergyPerTick", "getIdleEnergyPerTick()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StarCollector.class, "collectingEnergyPerTick", "getCollectingEnergyPerTick()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StarCollector.class, "mxIdleTime", "getMxIdleTime()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StarCollector.class, "maxCollectionTime", "getMaxCollectionTime()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(StarCollector.class, "timeSpentIdle", "getTimeSpentIdle()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(StarCollector.class, "timeSpentCollecting", "getTimeSpentCollecting()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @TileEntityMenuClass
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector$StarCollectorMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "<init>", "(Lxyz/xenondevs/nova/addon/machines/tileentity/world/StarCollector;)V", "sideConfigGui", "Lxyz/xenondevs/nova/ui/menu/sideconfig/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class StarCollectorMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public StarCollectorMenu() {
            super((TileEntity)StarCollector.this, null, 1, null);
            this.sideConfigGui = SideConfigMenuKt.SideConfigMenuItem((NetworkEndPoint)((NetworkEndPoint)StarCollector.this), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)StarCollector.this.itemHolder.getNetworkedInventory(StarCollector.this.inventory), (Object)"inventory.nova.output")), (Function1)((Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((StarCollectorMenu)((Object)this.receiver)).openWindow(p0);
                }
            }));
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # c p e |", "| u # i # c p e |", "| # # # # c p e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)((Gui.Builder)Gui.builder().setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(StarCollector.this.upgradeHolder))).addIngredient('i', (Inventory)StarCollector.this.inventory)).addIngredient('c', (Supplier)((Object)new IdleBar(3, "menu.machines.star_collector.collection", (Provider<Integer>)((Provider)StarCollector.this.timeSpentCollectingProvider), (Provider<Integer>)StarCollector.this.maxCollectionTimeProvider)))).addIngredient('p', (Supplier)((Object)new IdleBar(3, "menu.machines.star_collector.idle", (Provider<Integer>)((Provider)StarCollector.this.timeSpentIdleProvider), (Provider<Integer>)StarCollector.this.maxIdleTimeProvider)))).addIngredient('e', (Supplier)new EnergyBar(3, StarCollector.this.energyHolder, null, 4, null))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

