/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.addon.machines.util.HarvestAction;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.integration.customitems.CustomBlockType;
import xyz.xenondevs.nova.integration.customitems.CustomItemServiceManager;
import xyz.xenondevs.nova.integration.customitems.CustomItemType;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.NovaBlock;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0006R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/addon/machines/util/PlantUtils;", "", "<init>", "()V", "SEED_SOIL_BLOCKS", "", "Lorg/bukkit/Material;", "", "SEED_GROWTH_BLOCKS", "HARVESTABLE_PLANTS", "Lxyz/xenondevs/nova/addon/machines/util/HarvestAction;", "TREE_ATTACHMENTS", "isSeed", "", "item", "Lorg/bukkit/inventory/ItemStack;", "canBePlaced", "seed", "block", "Lorg/bukkit/block/Block;", "requiresFarmland", "placeSeed", "", "playEffects", "isHarvestable", "harvest", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockBreak;", "getHarvestDrops", "", "isTreeAttachment", "material", "machines"})
@SourceDebugExtension(value={"SMAP\nPlantUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlantUtils.kt\nxyz/xenondevs/nova/addon/machines/util/PlantUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,287:1\n1321#2,2:288\n*S KotlinDebug\n*F\n+ 1 PlantUtils.kt\nxyz/xenondevs/nova/addon/machines/util/PlantUtils\n*L\n204#1:288,2\n*E\n"})
public final class PlantUtils {
    @NotNull
    public static final PlantUtils INSTANCE = new PlantUtils();
    @NotNull
    private static final Map<Material, Set<Material>> SEED_SOIL_BLOCKS;
    @NotNull
    private static final Map<Material, Material> SEED_GROWTH_BLOCKS;
    @NotNull
    private static final Map<Material, HarvestAction> HARVESTABLE_PLANTS;
    @NotNull
    private static final Set<Material> TREE_ATTACHMENTS;

    private PlantUtils() {
    }

    public final boolean isSeed(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return CustomItemServiceManager.INSTANCE.getItemType(item) == CustomItemType.SEED || SEED_SOIL_BLOCKS.containsKey(item.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBePlaced(@NotNull ItemStack seed, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Block placeOn = BlockUtilsKt.getBelow((Block)block);
        if (CustomItemServiceManager.INSTANCE.getItemType(seed) == CustomItemType.SEED) {
            if (placeOn.getType() == Material.FARMLAND) return true;
        }
        Set<Material> set = SEED_SOIL_BLOCKS.get(seed.getType());
        if (set == null) return false;
        if (!set.contains(placeOn.getType())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean requiresFarmland(@NotNull ItemStack seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        if (CustomItemServiceManager.INSTANCE.getItemType(seed) == CustomItemType.SEED) return true;
        Set<Material> set = SEED_SOIL_BLOCKS.get(seed.getType());
        if (set == null) return false;
        if (!set.contains(Material.FARMLAND)) return false;
        return true;
    }

    public final void placeSeed(@NotNull ItemStack seed, @NotNull Block block, boolean playEffects) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        if (CustomItemServiceManager.INSTANCE.placeBlock(seed, location, playEffects)) {
            return;
        }
        Material material = SEED_GROWTH_BLOCKS.get(seed.getType());
        if (material == null) {
            Material material2 = seed.getType();
            material = material2;
            Intrinsics.checkNotNullExpressionValue((Object)material2, (String)"getType(...)");
        }
        Material newType = material;
        block.setType(newType);
        if (playEffects) {
            block.getWorld().playSound(block.getLocation(), MaterialUtilsKt.getSoundGroup((Material)newType).getPlaceSound(), 1.0f, (float)Random.Default.nextDouble(0.8, 0.95));
        }
    }

    public final boolean isHarvestable(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        NovaBlock novaBlock = BlockUtilsKt.getNovaBlock((Block)block);
        if (!(novaBlock == null || Intrinsics.areEqual((Object)novaBlock.getId().namespace(), (Object)"nova") && Tag.LEAVES.isTagged((Keyed)block.getType()))) {
            return false;
        }
        HarvestAction harvestAction = HARVESTABLE_PLANTS.get(block.getType());
        return harvestAction != null ? harvestAction.isHarvestable(block) : false;
    }

    public final void harvest(@NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        block0: {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            Object object = ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_POS());
            Intrinsics.checkNotNull((Object)object);
            Block block = ((BlockPos)object).getBlock();
            HarvestAction harvestAction = HARVESTABLE_PLANTS.get(block.getType());
            if (harvestAction == null) break block0;
            harvestAction.harvest(ctx);
        }
    }

    @NotNull
    public final List<ItemStack> getHarvestDrops(@NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        List list;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Object object = ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_POS());
        Intrinsics.checkNotNull((Object)object);
        Block block = ((BlockPos)object).getBlock();
        CustomBlockType customBlockType = CustomItemServiceManager.INSTANCE.getBlockType(block);
        if (customBlockType == CustomBlockType.NORMAL) {
            return CollectionsKt.emptyList();
        }
        List drops = null;
        if (customBlockType != CustomBlockType.CROP) {
            HarvestAction harvestAction = HARVESTABLE_PLANTS.get(block.getType());
            drops = harvestAction != null ? harvestAction.getDrops(ctx) : null;
        } else {
            drops = CustomItemServiceManager.INSTANCE.getDrops(block, null);
        }
        if ((list = drops) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isTreeAttachment(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        return TREE_ATTACHMENTS.contains(material);
    }

    private static final Iterable HARVESTABLE_PLANTS$lambda$5$putTags$lambda$2(Tag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = it.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getValues(...)");
        return set;
    }

    private static final boolean HARVESTABLE_PLANTS$lambda$5$putTags$lambda$3(Map $this_buildMap, Material it) {
        return !$this_buildMap.containsKey(it);
    }

    private static final void HARVESTABLE_PLANTS$lambda$5$putTags(Map<Material, HarvestAction> $this_buildMap, Tag<Material> ... tags) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)ArraysKt.asSequence((Object[])tags), PlantUtils::HARVESTABLE_PLANTS$lambda$5$putTags$lambda$2), arg_0 -> PlantUtils.HARVESTABLE_PLANTS$lambda$5$putTags$lambda$3($this_buildMap, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Material it = (Material)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $this_buildMap.put(it, HarvestAction.Simple.INSTANCE);
        }
    }

    static {
        Object object = MapsKt.createMapBuilder();
        Map $this$SEED_SOIL_BLOCKS_u24lambda_u240 = object;
        boolean bl = false;
        Object[] objectArray = new Material[]{Material.FARMLAND};
        HashSet farmland = SetsKt.hashSetOf((Object[])objectArray);
        Object[] objectArray2 = new Material[]{Material.FARMLAND, Material.GRASS_BLOCK, Material.DIRT, Material.COARSE_DIRT, Material.ROOTED_DIRT, Material.PODZOL, Material.MYCELIUM};
        HashSet defaultDirt = SetsKt.hashSetOf((Object[])objectArray2);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.WHEAT_SEEDS, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.BEETROOT_SEEDS, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.POTATO, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.CARROT, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.PUMPKIN_SEEDS, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.MELON_SEEDS, farmland);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.SWEET_BERRIES, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.OAK_SAPLING, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.SPRUCE_SAPLING, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.BIRCH_SAPLING, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.JUNGLE_SAPLING, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.ACACIA_SAPLING, defaultDirt);
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.DARK_OAK_SAPLING, defaultDirt);
        objectArray2 = new Material[]{Material.CRIMSON_NYLIUM};
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.CRIMSON_FUNGUS, SetsKt.hashSetOf((Object[])objectArray2));
        objectArray2 = new Material[]{Material.WARPED_NYLIUM};
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.WARPED_FUNGUS, SetsKt.hashSetOf((Object[])objectArray2));
        objectArray2 = new Material[]{Material.SOUL_SAND};
        $this$SEED_SOIL_BLOCKS_u24lambda_u240.put(Material.NETHER_WART, SetsKt.hashSetOf((Object[])objectArray2));
        SEED_SOIL_BLOCKS = MapsKt.build((Map)object);
        object = MapsKt.createMapBuilder();
        Map $this$SEED_GROWTH_BLOCKS_u24lambda_u241 = object;
        boolean bl2 = false;
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.WHEAT_SEEDS, Material.WHEAT);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.BEETROOT_SEEDS, Material.BEETROOTS);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.POTATO, Material.POTATOES);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.CARROT, Material.CARROTS);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.SWEET_BERRIES, Material.SWEET_BERRY_BUSH);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.PUMPKIN_SEEDS, Material.PUMPKIN_STEM);
        $this$SEED_GROWTH_BLOCKS_u24lambda_u241.put(Material.MELON_SEEDS, Material.MELON_STEM);
        SEED_GROWTH_BLOCKS = MapsKt.build((Map)object);
        object = MapsKt.createMapBuilder();
        Map $this$HARVESTABLE_PLANTS_u24lambda_u245 = object;
        boolean bl3 = false;
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.SHORT_GRASS, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.TALL_GRASS, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.BEE_NEST, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.PUMPKIN, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MELON, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.SHROOMLIGHT, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.WEEPING_VINES, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.WEEPING_VINES_PLANT, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MUSHROOM_STEM, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.RED_MUSHROOM_BLOCK, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.BROWN_MUSHROOM_BLOCK, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.VINE, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MANGROVE_ROOTS, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MUDDY_MANGROVE_ROOTS, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MOSS_CARPET, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.PALE_MOSS_CARPET, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.PALE_HANGING_MOSS, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.CREAKING_HEART, HarvestAction.Simple.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.WHEAT, HarvestAction.FullyAged.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.BEETROOTS, HarvestAction.FullyAged.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.POTATOES, HarvestAction.FullyAged.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.CARROTS, HarvestAction.FullyAged.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.CACTUS, HarvestAction.SameTypeBelow.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.SUGAR_CANE, HarvestAction.SameTypeBelow.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.SWEET_BERRY_BUSH, HarvestAction.SweetBerries.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.CAVE_VINES, HarvestAction.CaveVines.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.CAVE_VINES_PLANT, HarvestAction.CaveVines.INSTANCE);
        $this$HARVESTABLE_PLANTS_u24lambda_u245.put(Material.MANGROVE_PROPAGULE, HarvestAction.MangrovePropagule.INSTANCE);
        objectArray = new Tag[]{Tag.LEAVES, Tag.LOGS, Tag.FLOWERS, Tag.WART_BLOCKS};
        PlantUtils.HARVESTABLE_PLANTS$lambda$5$putTags($this$HARVESTABLE_PLANTS_u24lambda_u245, objectArray);
        HARVESTABLE_PLANTS = MapsKt.build((Map)object);
        Object $this$TREE_ATTACHMENTS_u24lambda_u246 = object = SetsKt.createSetBuilder();
        boolean bl4 = false;
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.BEE_NEST);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.SHROOMLIGHT);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.WEEPING_VINES);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.WEEPING_VINES_PLANT);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.MANGROVE_PROPAGULE);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.VINE);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.MOSS_CARPET);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.PALE_MOSS_CARPET);
        $this$TREE_ATTACHMENTS_u24lambda_u246.add(Material.PALE_HANGING_MOSS);
        TREE_ATTACHMENTS = SetsKt.build((Set)object);
    }
}

