/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld;

import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.common.io.file.configuration.ConfigurationHolder;
import com.dev7ex.common.io.file.configuration.ConfigurationProperties;
import com.dev7ex.common.io.file.configuration.YamlConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApiConfiguration;
import com.dev7ex.multiworld.api.world.WorldDefaultProperty;
import java.text.SimpleDateFormat;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

@ConfigurationProperties(fileName="config.yml", provider=YamlConfiguration.class)
public class MultiWorldConfiguration
extends MultiWorldBukkitApiConfiguration {
    private final ParsedMap<WorldDefaultProperty, Object> defaultProperties = new ParsedMap();

    public MultiWorldConfiguration(@NotNull ConfigurationHolder configurationHolder) {
        super(configurationHolder);
    }

    public void load() {
        super.load();
        boolean hasChanges = false;
        for (MultiWorldBukkitApiConfiguration.Entry entry2 : MultiWorldBukkitApiConfiguration.Entry.values()) {
            if (entry2.isRemoved() && super.getFileConfiguration().contains(entry2.getPath())) {
                super.getFileConfiguration().set(entry2.getPath(), null);
                MultiWorldPlugin.getInstance().getLogger().info("Removed unnecessary config entry: " + entry2.getPath());
                hasChanges = true;
            }
            if (entry2.isRemoved() || super.getFileConfiguration().contains(entry2.getPath())) continue;
            MultiWorldPlugin.getInstance().getLogger().info("Adding missing config entry: " + entry2.getPath());
            super.getFileConfiguration().set(entry2.getPath(), entry2.getDefaultValue());
            hasChanges = true;
        }
        if (hasChanges) {
            super.saveFile();
        }
        super.getFileConfiguration().getSection("settings.defaults").getKeys().forEach(entry -> this.defaultProperties.put((Object)WorldDefaultProperty.valueOf(entry.replaceAll("-", "_").toUpperCase()), super.getFileConfiguration().get("settings.defaults." + entry)));
    }

    @Override
    public String getMessage(@NotNull String path) {
        return super.getString(path).replaceAll("%prefix%", this.getPrefix());
    }

    @Override
    public SimpleDateFormat getTimeFormat() {
        return new SimpleDateFormat(super.getFileConfiguration().getString(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_TIME_FORMAT.getPath()));
    }

    @Override
    public boolean isAutoGameModeEnabled() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_AUTO_GAME_MODE_ENABLED.getPath());
    }

    @Override
    public boolean isWorldLinkEnabled() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_WORLD_LINK_ENABLED.getPath());
    }

    @Override
    public boolean isAutoUnloadSystemEnabled() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_AUTO_UNLOAD_SYSTEM_ENABLED.getPath());
    }

    @Override
    public long getAutoUnloadSystemDelay() {
        return super.getLong(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_AUTO_UNLOAD_SYSTEM_DELAY.getPath());
    }

    @Override
    public long getAutoUnloadLoadDelay() {
        return super.getLong(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_AUTO_UNLOAD_LOAD_DELAY.getPath());
    }

    @Override
    public boolean isAutoWorldImportEnabled() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_AUTO_WORLD_IMPORT_ENABLED.getPath());
    }

    @Override
    public boolean canNetherWorldAccessViaCommand() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_ACCESS_NETHER_WORLD_VIA_COMMAND.getPath());
    }

    @Override
    public boolean canEndWorldAccessViaCommand() {
        return super.getBoolean(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_ACCESS_END_WORLD_VIA_COMMAND.getPath());
    }

    @Override
    @Generated
    public ParsedMap<WorldDefaultProperty, Object> getDefaultProperties() {
        return this.defaultProperties;
    }
}

