/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld;

import com.dev7ex.common.bukkit.BukkitCommon;
import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.ConfigurablePlugin;
import com.dev7ex.common.bukkit.plugin.PluginIdentification;
import com.dev7ex.common.bukkit.plugin.module.PluginModule;
import com.dev7ex.common.bukkit.plugin.statistic.PluginStatisticProperties;
import com.dev7ex.common.io.file.configuration.ConfigurationHolder;
import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.api.MultiWorldApiProvider;
import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.command.WorldCommand;
import com.dev7ex.multiworld.hook.DefaultHookProvider;
import com.dev7ex.multiworld.listener.entity.EntityPortalListener;
import com.dev7ex.multiworld.listener.entity.EntitySpawnListener;
import com.dev7ex.multiworld.listener.player.PlayerAdvancementDoneListener;
import com.dev7ex.multiworld.listener.player.PlayerChangeWorldListener;
import com.dev7ex.multiworld.listener.player.PlayerConnectionListener;
import com.dev7ex.multiworld.listener.player.PlayerDamagePlayerListener;
import com.dev7ex.multiworld.listener.player.PlayerPortalListener;
import com.dev7ex.multiworld.listener.user.UserTeleportWorldListener;
import com.dev7ex.multiworld.listener.world.WorldActivityListener;
import com.dev7ex.multiworld.listener.world.WorldFlagListener;
import com.dev7ex.multiworld.listener.world.WorldInitializeListener;
import com.dev7ex.multiworld.task.WorldUnloadTask;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.user.UserProvider;
import com.dev7ex.multiworld.util.PluginUpdater;
import com.dev7ex.multiworld.world.DefaultWorldConfiguration;
import com.dev7ex.multiworld.world.DefaultWorldManager;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import com.dev7ex.multiworld.world.generator.DefaultWorldGeneratorProvider;
import java.io.File;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

@PluginIdentification(spigotResourceId=92559)
@PluginStatisticProperties(enabled=true, identification=15446)
public class MultiWorldPlugin
extends BukkitPlugin
implements MultiWorldBukkitApi,
ConfigurablePlugin {
    private MultiWorldConfiguration configuration;
    private DefaultWorldConfiguration worldConfiguration;
    private WorldCommand worldCommand;
    private final PluginUpdater updater = new PluginUpdater(this);
    private DefaultWorldManager worldManager;
    private WorldUnloadTask worldUnloadTask;
    private DefaultWorldProvider worldProvider;
    private UserProvider userProvider;
    private DefaultWorldGeneratorProvider worldGeneratorProvider;
    private DefaultHookProvider hookProvider;
    private DefaultTranslationProvider translationProvider;

    public void onLoad() {
        super.createDataFolder();
        super.createSubFolder("user");
        super.createSubFolder("backup");
        super.createSubFolder("language");
        this.configuration = new MultiWorldConfiguration((ConfigurationHolder)this);
        this.configuration.load();
        this.worldConfiguration = new DefaultWorldConfiguration(this);
        this.worldConfiguration.createFile();
        this.worldConfiguration.loadFile();
    }

    public void onEnable() {
        super.getServer().getServicesManager().register(MultiWorldBukkitApi.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        this.updater.checkAsync();
        if (!BukkitCommon.isPaper()) {
            this.getConsoleSender().sendMessage(this.configuration.getPrefix() + "\u00a7cMultiWorld will only support paper or paper forks in the future");
            this.getConsoleSender().sendMessage(this.configuration.getPrefix() + "\u00a7cPlease remember to switch early");
        }
        MultiWorldApiProvider.registerApi(this);
    }

    public void onDisable() {
        MultiWorldApiProvider.unregisterApi();
    }

    public void registerCommands() {
        this.worldCommand = new WorldCommand(this);
        super.registerCommand((BukkitCommand)this.worldCommand);
    }

    public void registerListeners() {
        super.registerListener((Listener)new EntityPortalListener(this));
        super.registerListener((Listener)new EntitySpawnListener(this));
        super.registerListener((Listener)new PlayerAdvancementDoneListener(this));
        super.registerListener((Listener)new PlayerChangeWorldListener(this));
        super.registerListener((Listener)new PlayerConnectionListener(this));
        super.registerListener((Listener)new PlayerDamagePlayerListener(this));
        super.registerListener((Listener)new PlayerPortalListener(this));
        super.registerListener((Listener)new UserTeleportWorldListener(this));
        super.registerListener((Listener)new WorldActivityListener(this));
        super.registerListener((Listener)new WorldFlagListener(this));
        super.registerListenerIf((Listener)new WorldInitializeListener(this), enableIf -> this.configuration.isAutoWorldImportEnabled());
    }

    public void registerModules() {
        this.translationProvider = new DefaultTranslationProvider(this);
        super.registerModule((PluginModule)this.translationProvider);
        this.worldManager = new DefaultWorldManager(this.worldConfiguration, this.configuration, this.translationProvider);
        this.worldGeneratorProvider = new DefaultWorldGeneratorProvider();
        super.registerModule((PluginModule)this.worldGeneratorProvider);
        this.worldProvider = new DefaultWorldProvider(this.worldManager, this.worldConfiguration);
        super.registerModule((PluginModule)this.worldProvider);
        this.userProvider = new UserProvider();
        super.registerModule((PluginModule)this.userProvider);
        this.hookProvider = new DefaultHookProvider();
        super.registerModule((PluginModule)this.hookProvider);
    }

    public void registerTasks() {
        this.worldUnloadTask = new WorldUnloadTask(this.getWorldProvider());
        super.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)((Object)this.worldUnloadTask), 20L, 20L);
    }

    @Override
    public File getBackupFolder() {
        return super.getSubFolder("backup");
    }

    @Override
    public File getUserFolder() {
        return super.getSubFolder("user");
    }

    @Override
    public ConsoleCommandSender getConsoleSender() {
        return Bukkit.getConsoleSender();
    }

    public static MultiWorldPlugin getInstance() {
        return (MultiWorldPlugin)JavaPlugin.getPlugin(MultiWorldPlugin.class);
    }

    @Override
    @Generated
    public MultiWorldConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public DefaultWorldConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    @Override
    @Generated
    public WorldCommand getWorldCommand() {
        return this.worldCommand;
    }

    @Generated
    public PluginUpdater getUpdater() {
        return this.updater;
    }

    @Override
    @Generated
    public DefaultWorldManager getWorldManager() {
        return this.worldManager;
    }

    @Generated
    public WorldUnloadTask getWorldUnloadTask() {
        return this.worldUnloadTask;
    }

    @Override
    @Generated
    public DefaultWorldProvider getWorldProvider() {
        return this.worldProvider;
    }

    @Override
    @Generated
    public UserProvider getUserProvider() {
        return this.userProvider;
    }

    @Override
    @Generated
    public DefaultWorldGeneratorProvider getWorldGeneratorProvider() {
        return this.worldGeneratorProvider;
    }

    @Generated
    public DefaultHookProvider getHookProvider() {
        return this.hookProvider;
    }

    @Override
    @Generated
    public DefaultTranslationProvider getTranslationProvider() {
        return this.translationProvider;
    }
}

