/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.bukkit.world;

import com.dev7ex.multiworld.api.MultiWorldApiProvider;
import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApiConfiguration;
import com.dev7ex.multiworld.api.bukkit.world.location.BukkitWorldLocation;
import com.dev7ex.multiworld.api.world.WorldFlag;
import com.dev7ex.multiworld.api.world.WorldHolder;
import com.dev7ex.multiworld.api.world.WorldType;
import com.dev7ex.multiworld.api.world.location.WorldLocation;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BukkitWorldHolder
implements WorldHolder {
    private String name;
    private String creatorName;
    private long creationTimeStamp;
    private boolean autoLoadEnabled;
    private boolean autoUnloadEnabled;
    private Difficulty difficulty;
    private boolean endPortalAccessible;
    private World.Environment environment;
    private GameMode gameMode;
    private String forceGameMode;
    private String generator;
    private boolean hungerEnabled;
    private boolean keepSpawnInMemory;
    private String endWorldName;
    private String netherWorldName;
    private String normalWorldName;
    private boolean netherPortalAccessible;
    private boolean pvpEnabled;
    private boolean receiveAchievements;
    private boolean redstoneEnabled;
    private boolean spawnAnimals;
    private boolean spawnMonsters;
    private boolean spawnEntities;
    private WorldType type;
    private boolean weatherEnabled;
    private List<String> whitelist = new ArrayList<String>();
    private boolean whitelistEnabled;
    private boolean loaded;
    private long loadTimeStamp;
    private long lastActivity;

    public World getWorld() {
        return Bukkit.getWorld((String)this.name);
    }

    @Override
    public WorldLocation getSpawnLocation() {
        return BukkitWorldLocation.of(this.getWorld().getSpawnLocation());
    }

    @Override
    public void updateFlag(@NotNull WorldFlag flag, @NotNull String value) {
        block0 : switch (flag) {
            case AUTO_LOAD_ENABLED: {
                this.autoLoadEnabled = Boolean.parseBoolean(value);
                break;
            }
            case AUTO_UNLOAD_ENABLED: {
                this.autoUnloadEnabled = Boolean.parseBoolean(value);
                break;
            }
            case DIFFICULTY: {
                this.difficulty = Difficulty.valueOf((String)value);
                if (!this.loaded) break;
                this.getWorld().setDifficulty(this.difficulty);
                break;
            }
            case END_PORTAL_ACCESSIBLE: {
                this.endPortalAccessible = Boolean.parseBoolean(value);
                break;
            }
            case GAME_MODE: {
                this.gameMode = GameMode.valueOf((String)value);
                this.getWorld().getPlayers().forEach(player -> player.setGameMode(this.gameMode));
                break;
            }
            case FORCE_GAME_MODE: {
                GameMode gameMode = (GameMode)MultiWorldApiProvider.getMultiWorldApi().getWorldConfiguration().getWorldHolder(this.getWorld().getName()).getGameMode();
                switch (value) {
                    case "true": {
                        this.forceGameMode = "true";
                        this.getWorld().getPlayers().forEach(player -> player.setGameMode(gameMode));
                        break;
                    }
                    case "false": {
                        this.forceGameMode = "false";
                        break;
                    }
                    case "false_with_permission": {
                        this.forceGameMode = "false_with_permission";
                        for (Player player2 : this.getWorld().getPlayers()) {
                            if (player2.hasPermission("multiworld.bypass.forcegamemode")) continue;
                            player2.setGameMode(gameMode);
                        }
                        break block0;
                    }
                    default: {
                        this.forceGameMode = MultiWorldApiProvider.getMultiWorldApi().getConfiguration().getString(MultiWorldBukkitApiConfiguration.Entry.SETTINGS_DEFAULTS_FORCE_GAME_MODE.getPath());
                        break;
                    }
                }
                break;
            }
            case HUNGER_ENABLED: {
                this.hungerEnabled = Boolean.parseBoolean(value);
                if (this.hungerEnabled) break;
                this.getWorld().getPlayers().forEach(player -> player.setSaturation(20.0f));
                break;
            }
            case KEEP_SPAWN_IN_MEMORY: {
                this.keepSpawnInMemory = Boolean.parseBoolean(value);
                this.getWorld().setKeepSpawnInMemory(this.keepSpawnInMemory);
                break;
            }
            case NETHER_PORTAL_ACCESSIBLE: {
                this.netherPortalAccessible = Boolean.parseBoolean(value);
                break;
            }
            case PVP_ENABLED: {
                this.pvpEnabled = Boolean.parseBoolean(value);
                break;
            }
            case RECEIVE_ACHIEVEMENTS: {
                this.receiveAchievements = Boolean.parseBoolean(value);
                break;
            }
            case REDSTONE_ENABLED: {
                this.redstoneEnabled = Boolean.parseBoolean(value);
                break;
            }
            case SPAWN_ANIMALS: {
                this.spawnAnimals = Boolean.parseBoolean(value);
                if (!this.loaded) break;
                this.getWorld().setSpawnFlags(this.spawnMonsters, this.spawnAnimals);
                this.getWorld().getEntities().stream().filter(entity -> entity instanceof Animals).forEach(Entity::remove);
                break;
            }
            case SPAWN_MONSTERS: {
                this.spawnMonsters = Boolean.parseBoolean(value);
                if (!this.loaded) break;
                this.getWorld().setSpawnFlags(this.spawnMonsters, this.spawnAnimals);
                this.getWorld().getEntities().stream().filter(entity -> entity instanceof Monster).forEach(Entity::remove);
                break;
            }
            case SPAWN_ENTITIES: {
                this.spawnEntities = Boolean.parseBoolean(value);
                break;
            }
            case WEATHER_ENABLED: {
                this.weatherEnabled = Boolean.parseBoolean(value);
            }
        }
    }

    public BukkitWorldHolder clone() {
        try {
            return (BukkitWorldHolder)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError();
        }
    }

    @Generated
    BukkitWorldHolder(String name, String creatorName, long creationTimeStamp, boolean autoLoadEnabled, boolean autoUnloadEnabled, Difficulty difficulty, boolean endPortalAccessible, World.Environment environment, GameMode gameMode, String forceGameMode, String generator, boolean hungerEnabled, boolean keepSpawnInMemory, String endWorldName, String netherWorldName, String normalWorldName, boolean netherPortalAccessible, boolean pvpEnabled, boolean receiveAchievements, boolean redstoneEnabled, boolean spawnAnimals, boolean spawnMonsters, boolean spawnEntities, WorldType type, boolean weatherEnabled, List<String> whitelist, boolean whitelistEnabled, boolean loaded, long loadTimeStamp, long lastActivity) {
        this.name = name;
        this.creatorName = creatorName;
        this.creationTimeStamp = creationTimeStamp;
        this.autoLoadEnabled = autoLoadEnabled;
        this.autoUnloadEnabled = autoUnloadEnabled;
        this.difficulty = difficulty;
        this.endPortalAccessible = endPortalAccessible;
        this.environment = environment;
        this.gameMode = gameMode;
        this.forceGameMode = forceGameMode;
        this.generator = generator;
        this.hungerEnabled = hungerEnabled;
        this.keepSpawnInMemory = keepSpawnInMemory;
        this.endWorldName = endWorldName;
        this.netherWorldName = netherWorldName;
        this.normalWorldName = normalWorldName;
        this.netherPortalAccessible = netherPortalAccessible;
        this.pvpEnabled = pvpEnabled;
        this.receiveAchievements = receiveAchievements;
        this.redstoneEnabled = redstoneEnabled;
        this.spawnAnimals = spawnAnimals;
        this.spawnMonsters = spawnMonsters;
        this.spawnEntities = spawnEntities;
        this.type = type;
        this.weatherEnabled = weatherEnabled;
        this.whitelist = whitelist;
        this.whitelistEnabled = whitelistEnabled;
        this.loaded = loaded;
        this.loadTimeStamp = loadTimeStamp;
        this.lastActivity = lastActivity;
    }

    @Generated
    public static BukkitWorldHolderBuilder builder() {
        return new BukkitWorldHolderBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getCreatorName() {
        return this.creatorName;
    }

    @Override
    @Generated
    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    @Override
    @Generated
    public boolean isAutoLoadEnabled() {
        return this.autoLoadEnabled;
    }

    @Override
    @Generated
    public boolean isAutoUnloadEnabled() {
        return this.autoUnloadEnabled;
    }

    @Generated
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    @Generated
    public boolean isEndPortalAccessible() {
        return this.endPortalAccessible;
    }

    @Generated
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Override
    @Generated
    public String getForceGameMode() {
        return this.forceGameMode;
    }

    @Generated
    public String getGenerator() {
        return this.generator;
    }

    @Override
    @Generated
    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    @Override
    @Generated
    public boolean isKeepSpawnInMemory() {
        return this.keepSpawnInMemory;
    }

    @Override
    @Generated
    public String getEndWorldName() {
        return this.endWorldName;
    }

    @Override
    @Generated
    public String getNetherWorldName() {
        return this.netherWorldName;
    }

    @Override
    @Generated
    public String getNormalWorldName() {
        return this.normalWorldName;
    }

    @Override
    @Generated
    public boolean isNetherPortalAccessible() {
        return this.netherPortalAccessible;
    }

    @Override
    @Generated
    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    @Override
    @Generated
    public boolean isReceiveAchievements() {
        return this.receiveAchievements;
    }

    @Override
    @Generated
    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    @Override
    @Generated
    public boolean isSpawnAnimals() {
        return this.spawnAnimals;
    }

    @Override
    @Generated
    public boolean isSpawnMonsters() {
        return this.spawnMonsters;
    }

    @Override
    @Generated
    public boolean isSpawnEntities() {
        return this.spawnEntities;
    }

    @Override
    @Generated
    public WorldType getType() {
        return this.type;
    }

    @Override
    @Generated
    public boolean isWeatherEnabled() {
        return this.weatherEnabled;
    }

    @Override
    @Generated
    public List<String> getWhitelist() {
        return this.whitelist;
    }

    @Override
    @Generated
    public boolean isWhitelistEnabled() {
        return this.whitelistEnabled;
    }

    @Override
    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    @Generated
    public long getLoadTimeStamp() {
        return this.loadTimeStamp;
    }

    @Override
    @Generated
    public long getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    @Generated
    public void setCreationTimeStamp(long creationTimeStamp) {
        this.creationTimeStamp = creationTimeStamp;
    }

    @Generated
    public void setAutoLoadEnabled(boolean autoLoadEnabled) {
        this.autoLoadEnabled = autoLoadEnabled;
    }

    @Override
    @Generated
    public void setAutoUnloadEnabled(boolean autoUnloadEnabled) {
        this.autoUnloadEnabled = autoUnloadEnabled;
    }

    @Generated
    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    @Generated
    public void setEndPortalAccessible(boolean endPortalAccessible) {
        this.endPortalAccessible = endPortalAccessible;
    }

    @Generated
    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Generated
    public void setForceGameMode(String forceGameMode) {
        this.forceGameMode = forceGameMode;
    }

    @Generated
    public void setGenerator(String generator) {
        this.generator = generator;
    }

    @Override
    @Generated
    public void setHungerEnabled(boolean hungerEnabled) {
        this.hungerEnabled = hungerEnabled;
    }

    @Override
    @Generated
    public void setKeepSpawnInMemory(boolean keepSpawnInMemory) {
        this.keepSpawnInMemory = keepSpawnInMemory;
    }

    @Override
    @Generated
    public void setEndWorldName(String endWorldName) {
        this.endWorldName = endWorldName;
    }

    @Override
    @Generated
    public void setNetherWorldName(String netherWorldName) {
        this.netherWorldName = netherWorldName;
    }

    @Override
    @Generated
    public void setNormalWorldName(String normalWorldName) {
        this.normalWorldName = normalWorldName;
    }

    @Override
    @Generated
    public void setNetherPortalAccessible(boolean netherPortalAccessible) {
        this.netherPortalAccessible = netherPortalAccessible;
    }

    @Generated
    public void setPvpEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
    }

    @Override
    @Generated
    public void setReceiveAchievements(boolean receiveAchievements) {
        this.receiveAchievements = receiveAchievements;
    }

    @Override
    @Generated
    public void setRedstoneEnabled(boolean redstoneEnabled) {
        this.redstoneEnabled = redstoneEnabled;
    }

    @Generated
    public void setSpawnAnimals(boolean spawnAnimals) {
        this.spawnAnimals = spawnAnimals;
    }

    @Generated
    public void setSpawnMonsters(boolean spawnMonsters) {
        this.spawnMonsters = spawnMonsters;
    }

    @Generated
    public void setSpawnEntities(boolean spawnEntities) {
        this.spawnEntities = spawnEntities;
    }

    @Generated
    public void setType(WorldType type) {
        this.type = type;
    }

    @Override
    @Generated
    public void setWeatherEnabled(boolean weatherEnabled) {
        this.weatherEnabled = weatherEnabled;
    }

    @Generated
    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    @Override
    @Generated
    public void setWhitelistEnabled(boolean whitelistEnabled) {
        this.whitelistEnabled = whitelistEnabled;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Override
    @Generated
    public void setLoadTimeStamp(long loadTimeStamp) {
        this.loadTimeStamp = loadTimeStamp;
    }

    @Override
    @Generated
    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public static class BukkitWorldHolderBuilder {
        @Generated
        private String name;
        @Generated
        private String creatorName;
        @Generated
        private long creationTimeStamp;
        @Generated
        private boolean autoLoadEnabled;
        @Generated
        private boolean autoUnloadEnabled;
        @Generated
        private Difficulty difficulty;
        @Generated
        private boolean endPortalAccessible;
        @Generated
        private World.Environment environment;
        @Generated
        private GameMode gameMode;
        @Generated
        private String forceGameMode;
        @Generated
        private String generator;
        @Generated
        private boolean hungerEnabled;
        @Generated
        private boolean keepSpawnInMemory;
        @Generated
        private String endWorldName;
        @Generated
        private String netherWorldName;
        @Generated
        private String normalWorldName;
        @Generated
        private boolean netherPortalAccessible;
        @Generated
        private boolean pvpEnabled;
        @Generated
        private boolean receiveAchievements;
        @Generated
        private boolean redstoneEnabled;
        @Generated
        private boolean spawnAnimals;
        @Generated
        private boolean spawnMonsters;
        @Generated
        private boolean spawnEntities;
        @Generated
        private WorldType type;
        @Generated
        private boolean weatherEnabled;
        @Generated
        private List<String> whitelist;
        @Generated
        private boolean whitelistEnabled;
        @Generated
        private boolean loaded;
        @Generated
        private long loadTimeStamp;
        @Generated
        private long lastActivity;

        @Generated
        BukkitWorldHolderBuilder() {
        }

        @Generated
        public BukkitWorldHolderBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setCreatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setCreationTimeStamp(long creationTimeStamp) {
            this.creationTimeStamp = creationTimeStamp;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setAutoLoadEnabled(boolean autoLoadEnabled) {
            this.autoLoadEnabled = autoLoadEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setAutoUnloadEnabled(boolean autoUnloadEnabled) {
            this.autoUnloadEnabled = autoUnloadEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setDifficulty(Difficulty difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setEndPortalAccessible(boolean endPortalAccessible) {
            this.endPortalAccessible = endPortalAccessible;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setEnvironment(World.Environment environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setGameMode(GameMode gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setForceGameMode(String forceGameMode) {
            this.forceGameMode = forceGameMode;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setGenerator(String generator) {
            this.generator = generator;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setHungerEnabled(boolean hungerEnabled) {
            this.hungerEnabled = hungerEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setKeepSpawnInMemory(boolean keepSpawnInMemory) {
            this.keepSpawnInMemory = keepSpawnInMemory;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setEndWorldName(String endWorldName) {
            this.endWorldName = endWorldName;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setNetherWorldName(String netherWorldName) {
            this.netherWorldName = netherWorldName;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setNormalWorldName(String normalWorldName) {
            this.normalWorldName = normalWorldName;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setNetherPortalAccessible(boolean netherPortalAccessible) {
            this.netherPortalAccessible = netherPortalAccessible;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setPvpEnabled(boolean pvpEnabled) {
            this.pvpEnabled = pvpEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setReceiveAchievements(boolean receiveAchievements) {
            this.receiveAchievements = receiveAchievements;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setRedstoneEnabled(boolean redstoneEnabled) {
            this.redstoneEnabled = redstoneEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setSpawnAnimals(boolean spawnAnimals) {
            this.spawnAnimals = spawnAnimals;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setSpawnMonsters(boolean spawnMonsters) {
            this.spawnMonsters = spawnMonsters;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setSpawnEntities(boolean spawnEntities) {
            this.spawnEntities = spawnEntities;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setType(WorldType type) {
            this.type = type;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setWeatherEnabled(boolean weatherEnabled) {
            this.weatherEnabled = weatherEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setWhitelist(List<String> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setWhitelistEnabled(boolean whitelistEnabled) {
            this.whitelistEnabled = whitelistEnabled;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setLoaded(boolean loaded) {
            this.loaded = loaded;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setLoadTimeStamp(long loadTimeStamp) {
            this.loadTimeStamp = loadTimeStamp;
            return this;
        }

        @Generated
        public BukkitWorldHolderBuilder setLastActivity(long lastActivity) {
            this.lastActivity = lastActivity;
            return this;
        }

        @Generated
        public BukkitWorldHolder build() {
            return new BukkitWorldHolder(this.name, this.creatorName, this.creationTimeStamp, this.autoLoadEnabled, this.autoUnloadEnabled, this.difficulty, this.endPortalAccessible, this.environment, this.gameMode, this.forceGameMode, this.generator, this.hungerEnabled, this.keepSpawnInMemory, this.endWorldName, this.netherWorldName, this.normalWorldName, this.netherPortalAccessible, this.pvpEnabled, this.receiveAchievements, this.redstoneEnabled, this.spawnAnimals, this.spawnMonsters, this.spawnEntities, this.type, this.weatherEnabled, this.whitelist, this.whitelistEnabled, this.loaded, this.loadTimeStamp, this.lastActivity);
        }

        @Generated
        public String toString() {
            return "BukkitWorldHolder.BukkitWorldHolderBuilder(name=" + this.name + ", creatorName=" + this.creatorName + ", creationTimeStamp=" + this.creationTimeStamp + ", autoLoadEnabled=" + this.autoLoadEnabled + ", autoUnloadEnabled=" + this.autoUnloadEnabled + ", difficulty=" + String.valueOf(this.difficulty) + ", endPortalAccessible=" + this.endPortalAccessible + ", environment=" + String.valueOf(this.environment) + ", gameMode=" + String.valueOf(this.gameMode) + ", forceGameMode=" + this.forceGameMode + ", generator=" + this.generator + ", hungerEnabled=" + this.hungerEnabled + ", keepSpawnInMemory=" + this.keepSpawnInMemory + ", endWorldName=" + this.endWorldName + ", netherWorldName=" + this.netherWorldName + ", normalWorldName=" + this.normalWorldName + ", netherPortalAccessible=" + this.netherPortalAccessible + ", pvpEnabled=" + this.pvpEnabled + ", receiveAchievements=" + this.receiveAchievements + ", redstoneEnabled=" + this.redstoneEnabled + ", spawnAnimals=" + this.spawnAnimals + ", spawnMonsters=" + this.spawnMonsters + ", spawnEntities=" + this.spawnEntities + ", type=" + String.valueOf((Object)this.type) + ", weatherEnabled=" + this.weatherEnabled + ", whitelist=" + String.valueOf(this.whitelist) + ", whitelistEnabled=" + this.whitelistEnabled + ", loaded=" + this.loaded + ", loadTimeStamp=" + this.loadTimeStamp + ", lastActivity=" + this.lastActivity + ")";
        }
    }
}

