/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.bukkit.world.generator.defaults;

import com.dev7ex.multiworld.api.bukkit.world.generator.BukkitWorldGenerator;
import java.util.Random;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class VoidWorldGenerator
extends BukkitWorldGenerator {
    public VoidWorldGenerator(@NotNull Plugin plugin) {
        super(plugin);
    }

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunkData = super.createChunkData(world);
        if (x == 0 && z == 0) {
            chunkData.setBlock(0, 63, 0, Material.STONE);
            world.setSpawnLocation(new Location(world, 0.0, 64.0, 0.0));
        }
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                if (biome.getBiome(chunkX, chunkZ) == Biome.PLAINS) continue;
                biome.setBiome(chunkX, chunkZ, Biome.PLAINS);
            }
        }
        return chunkData;
    }

    @Generated
    public VoidWorldGenerator() {
    }
}

