/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.bukkit.world.generator.defaults;

import com.dev7ex.multiworld.api.bukkit.world.generator.BukkitWorldGenerator;
import java.util.Random;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WaterWorldGenerator
extends BukkitWorldGenerator {
    public WaterWorldGenerator(@NotNull Plugin plugin) {
        super(plugin);
    }

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunkData = super.createChunkData(world);
        chunkData.setRegion(0, 0, 0, 16, 1, 16, Material.BEDROCK);
        chunkData.setRegion(0, 1, 0, 16, 64, 16, Material.WATER);
        if (x == 0 && z == 0) {
            chunkData.setBlock(0, 63, 0, Material.STONE);
            world.setSpawnLocation(new Location(world, 0.0, 64.0, 0.0));
        }
        for (int chunkX = 0; chunkX < 15; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 15; ++chunkZ) {
                if (biome.getBiome(chunkX, chunkZ) == Biome.OCEAN) continue;
                biome.setBiome(chunkX, chunkZ, Biome.OCEAN);
            }
        }
        return chunkData;
    }

    @Generated
    public WaterWorldGenerator() {
    }
}

