/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.bukkit.world.location;

import com.dev7ex.multiworld.api.world.location.WorldLocation;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class BukkitWorldLocation
implements WorldLocation {
    private String worldName;
    private double x;
    private double z;
    private double y;
    private double yaw;
    private double pitch;

    public BukkitWorldLocation(@NotNull String worldName, double x, double y, double z, double yaw, double pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public static BukkitWorldLocation of(@NotNull Location location) {
        BukkitWorldLocation worldLocation = new BukkitWorldLocation();
        worldLocation.setWorldName(location.getWorld().getName());
        worldLocation.setX(location.getX());
        worldLocation.setY(location.getY());
        worldLocation.setZ(location.getZ());
        worldLocation.setYaw(location.getYaw());
        worldLocation.setPitch(location.getPitch());
        return worldLocation;
    }

    public static Location to(@NotNull WorldLocation location) {
        return new Location(Bukkit.getWorld((String)location.getWorldName()), location.getX(), location.getY(), location.getZ(), (float)location.getYaw(), (float)location.getPitch());
    }

    @Generated
    public static BukkitWorldLocationBuilder builder() {
        return new BukkitWorldLocationBuilder();
    }

    @Override
    @Generated
    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    @Override
    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Override
    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Override
    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Override
    @Generated
    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    @Override
    @Generated
    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    @Override
    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    @Generated
    public double getX() {
        return this.x;
    }

    @Override
    @Generated
    public double getZ() {
        return this.z;
    }

    @Override
    @Generated
    public double getY() {
        return this.y;
    }

    @Override
    @Generated
    public double getYaw() {
        return this.yaw;
    }

    @Override
    @Generated
    public double getPitch() {
        return this.pitch;
    }

    @Generated
    public BukkitWorldLocation() {
    }

    @Generated
    public static class BukkitWorldLocationBuilder {
        @Generated
        private String worldName;
        @Generated
        private double x;
        @Generated
        private double z;
        @Generated
        private double y;
        @Generated
        private double yaw;
        @Generated
        private double pitch;

        @Generated
        BukkitWorldLocationBuilder() {
        }

        @Generated
        public BukkitWorldLocationBuilder setWorldName(String worldName) {
            this.worldName = worldName;
            return this;
        }

        @Generated
        public BukkitWorldLocationBuilder setX(double x) {
            this.x = x;
            return this;
        }

        @Generated
        public BukkitWorldLocationBuilder setZ(double z) {
            this.z = z;
            return this;
        }

        @Generated
        public BukkitWorldLocationBuilder setY(double y) {
            this.y = y;
            return this;
        }

        @Generated
        public BukkitWorldLocationBuilder setYaw(double yaw) {
            this.yaw = yaw;
            return this;
        }

        @Generated
        public BukkitWorldLocationBuilder setPitch(double pitch) {
            this.pitch = pitch;
            return this;
        }

        @Generated
        public BukkitWorldLocation build() {
            return new BukkitWorldLocation(this.worldName, this.x, this.z, this.y, this.yaw, this.pitch);
        }

        @Generated
        public String toString() {
            return "BukkitWorldLocation.BukkitWorldLocationBuilder(worldName=" + this.worldName + ", x=" + this.x + ", z=" + this.z + ", y=" + this.y + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
        }
    }
}

