/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.world;

import com.dev7ex.multiworld.api.world.WorldType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public enum WorldEnvironment {
    CUSTOM,
    NORMAL,
    NETHER,
    THE_END;


    public static WorldEnvironment fromType(WorldType worldType) {
        return switch (worldType) {
            case WorldType.THE_END -> THE_END;
            case WorldType.NETHER -> NETHER;
            case WorldType.NORMAL -> NORMAL;
            default -> CUSTOM;
        };
    }

    public static List<String> toStringList() {
        return Arrays.stream(WorldEnvironment.values()).map(Enum::name).toList();
    }

    public static Optional<WorldEnvironment> fromString(@NotNull String name) {
        return Arrays.stream(WorldEnvironment.values()).filter(worldType -> worldType.name().equalsIgnoreCase(name)).findFirst();
    }
}

