/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.api.world;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public enum WorldFlag {
    AUTO_LOAD_ENABLED("flag.auto-load-enabled", List.of("false", "true")),
    AUTO_UNLOAD_ENABLED("flag.auto-unload-enabled", List.of("false", "true")),
    DIFFICULTY("flag.difficulty", List.of("EASY", "HARD", "NORMAL", "PEACEFUL")),
    END_PORTAL_ACCESSIBLE("flag.end-portal-accessible", List.of("false", "true")),
    GAME_MODE("flag.game-mode", List.of("ADVENTURE", "CREATIVE", "SURVIVAL", "SPECTATOR")),
    FORCE_GAME_MODE("flag.force-game-mode", List.of("false", "true", "false-with-permission")),
    HUNGER_ENABLED("flag.hunger-enabled", List.of("false", "true")),
    KEEP_SPAWN_IN_MEMORY("flag.keep-spawn-in-memory", List.of("false", "true")),
    NETHER_PORTAL_ACCESSIBLE("flag.nether-portal-accessible", List.of("false", "true")),
    PVP_ENABLED("flag.pvp-enabled", List.of("false", "true")),
    RECEIVE_ACHIEVEMENTS("flag.receive-achievements", List.of("false", "true")),
    REDSTONE_ENABLED("flag.redstone-enabled", List.of("false", "true")),
    SPAWN_ANIMALS("flag.spawn-animals", List.of("false", "true")),
    SPAWN_ENTITIES("flag.spawn-entities", List.of("false", "true")),
    SPAWN_MONSTERS("flag.spawn-monsters", List.of("false", "true")),
    WEATHER_ENABLED("flag.weather-enabled", List.of("false", "true"));

    private final String storagePath;
    private final List<String> values;

    private WorldFlag(String storagePath, List<String> values) {
        this.storagePath = storagePath;
        this.values = values;
    }

    public static List<String> toStringList() {
        return Arrays.stream(WorldFlag.values()).map(Enum::name).toList();
    }

    public static Optional<WorldFlag> fromString(String name) {
        return Arrays.stream(WorldFlag.values()).filter(worldFlag -> worldFlag.name().equalsIgnoreCase(name)).findFirst();
    }

    @Generated
    public String getStoragePath() {
        return this.storagePath;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }
}

