/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.world.BackCommand;
import com.dev7ex.multiworld.command.world.BackupCommand;
import com.dev7ex.multiworld.command.world.CloneCommand;
import com.dev7ex.multiworld.command.world.CreateCommand;
import com.dev7ex.multiworld.command.world.DeleteCommand;
import com.dev7ex.multiworld.command.world.FlagCommand;
import com.dev7ex.multiworld.command.world.GameRuleCommand;
import com.dev7ex.multiworld.command.world.HelpCommand;
import com.dev7ex.multiworld.command.world.ImportCommand;
import com.dev7ex.multiworld.command.world.InfoCommand;
import com.dev7ex.multiworld.command.world.LinkCommand;
import com.dev7ex.multiworld.command.world.ListCommand;
import com.dev7ex.multiworld.command.world.LoadCommand;
import com.dev7ex.multiworld.command.world.ReloadCommand;
import com.dev7ex.multiworld.command.world.TeleportCommand;
import com.dev7ex.multiworld.command.world.UnloadCommand;
import com.dev7ex.multiworld.command.world.VersionCommand;
import com.dev7ex.multiworld.command.world.WhitelistCommand;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="world", permission="multiworld.command.world")
public class WorldCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;

    public WorldCommand(MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        super.registerSubCommand((BukkitCommand)new BackCommand(plugin));
        super.registerSubCommand((BukkitCommand)new BackupCommand(plugin));
        super.registerSubCommand((BukkitCommand)new CloneCommand(plugin));
        super.registerSubCommand((BukkitCommand)new CreateCommand(plugin));
        super.registerSubCommand((BukkitCommand)new DeleteCommand(plugin));
        super.registerSubCommand((BukkitCommand)new FlagCommand(plugin));
        super.registerSubCommand((BukkitCommand)new GameRuleCommand(plugin));
        super.registerSubCommand((BukkitCommand)new HelpCommand(plugin));
        super.registerSubCommand((BukkitCommand)new ImportCommand(plugin));
        super.registerSubCommand((BukkitCommand)new InfoCommand(plugin));
        super.registerSubCommand((BukkitCommand)new LinkCommand(plugin));
        super.registerSubCommand((BukkitCommand)new ListCommand(plugin));
        super.registerSubCommand((BukkitCommand)new LoadCommand(plugin));
        super.registerSubCommand((BukkitCommand)new ReloadCommand(plugin));
        super.registerSubCommand((BukkitCommand)new TeleportCommand(plugin));
        super.registerSubCommand((BukkitCommand)new UnloadCommand(plugin));
        super.registerSubCommand((BukkitCommand)new VersionCommand(plugin));
        super.registerSubCommand((BukkitCommand)new WhitelistCommand(plugin));
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length == 0 || arguments.length > 5) {
            Objects.requireNonNull(super.getSubCommand(HelpCommand.class)).execute(commandSender, arguments);
            return;
        }
        if (super.getSubCommand(arguments[0].toLowerCase()).isEmpty()) {
            Objects.requireNonNull(super.getSubCommand(HelpCommand.class)).execute(commandSender, arguments);
            return;
        }
        BukkitCommand subCommand = (BukkitCommand)super.getSubCommand(arguments[0].toLowerCase()).get();
        if (!commandSender.hasPermission(subCommand.getPermission())) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.no-permission").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        ((BukkitCommand)super.getSubCommand(arguments[0].toLowerCase()).get()).execute(commandSender, arguments);
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length == 1) {
            return Lists.newArrayList(super.getSubCommands().keySet());
        }
        if (super.getSubCommand(arguments[0].toLowerCase()).isEmpty()) {
            return Collections.emptyList();
        }
        BukkitCommand subCommand = (BukkitCommand)super.getSubCommand(arguments[0].toLowerCase()).get();
        if (!commandSender.hasPermission(subCommand.getPermission())) {
            return Collections.emptyList();
        }
        if (!(subCommand instanceof BukkitTabCompleter)) {
            return Collections.emptyList();
        }
        return ((BukkitTabCompleter)subCommand).onTabComplete(commandSender, arguments);
    }
}

