/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldManager;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="clone", permission="multiworld.command.world.clone")
public class CloneCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldManager worldManager;
    private final DefaultWorldProvider worldProvider;

    public CloneCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldManager = plugin.getWorldManager();
        this.worldProvider = plugin.getWorldProvider();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length != 3) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "messages.commands.clone.usage").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        if (arguments[2].equalsIgnoreCase("%creator_name%")) {
            arguments[2] = arguments[2].replaceAll("%creator_name%", commandSender.getName());
        }
        if (MultiWorldPlugin.getInstance().getWorldProvider().isRegistered(arguments[2])) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.world.already-exists").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[2]));
            return;
        }
        this.worldManager.cloneWorld(commandSender.getName(), arguments[1], arguments[2]);
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length != 2) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.worldProvider.getWorldHolders().keySet());
    }
}

