/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.util.Numbers;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.world.WorldEnvironment;
import com.dev7ex.multiworld.api.world.WorldType;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldManager;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import com.dev7ex.multiworld.world.generator.DefaultWorldGeneratorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="create", permission="multiworld.command.world.create")
public class CreateCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldManager worldManager;
    private final DefaultWorldProvider worldProvider;
    private final DefaultWorldGeneratorProvider worldGeneratorProvider;

    public CreateCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldManager = plugin.getWorldManager();
        this.worldProvider = plugin.getWorldProvider();
        this.worldGeneratorProvider = plugin.getWorldGeneratorProvider();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length != 5) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.usage").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        if (arguments[1].equalsIgnoreCase("%creator_name%")) {
            arguments[1] = arguments[1].replaceAll("%creator_name%", commandSender.getName());
        }
        if (this.worldProvider.isRegistered(arguments[1])) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.world.already-exists").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[1]));
            return;
        }
        Optional<WorldEnvironment> environmentOptional = WorldEnvironment.fromString(arguments[2].toUpperCase());
        if (environmentOptional.isEmpty()) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.world.environment-not-exists").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%environment_name%", arguments[2]));
            return;
        }
        WorldEnvironment environment = environmentOptional.get();
        switch (arguments[3]) {
            case "-s": {
                if (!Numbers.isLong((String)arguments[4])) {
                    commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.invalid-seed").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%seed%", arguments[4]));
                    return;
                }
                this.worldManager.createWorld(commandSender.getName(), arguments[1], environment, Long.parseLong(arguments[4]));
                break;
            }
            case "-g": {
                DefaultWorldGeneratorProvider generatorProvider = MultiWorldPlugin.getInstance().getWorldGeneratorProvider();
                if (!generatorProvider.isRegistered(arguments[4])) {
                    commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.invalid-generator").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%generator_name%", arguments[4]));
                    return;
                }
                this.worldManager.createWorld(commandSender.getName(), arguments[1], environment, arguments[4]);
                break;
            }
            case "-t": {
                Optional<WorldType> typeOptional = WorldType.fromString(arguments[4].toUpperCase());
                if (typeOptional.isEmpty()) {
                    commandSender.sendMessage(super.getConfiguration().getString("general.world.type-not-exist").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
                    return;
                }
                this.worldManager.createWorld(commandSender.getName(), arguments[1], typeOptional.get());
            }
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length < 2 || arguments.length > 5) {
            return Collections.emptyList();
        }
        if (arguments.length == 2) {
            return List.of("%creator_name%");
        }
        if (arguments.length == 3) {
            return WorldType.toStringList();
        }
        if (arguments.length == 4) {
            return List.of("-g", "-s", "-t");
        }
        return switch (arguments[3]) {
            case "-g" -> new ArrayList<String>(this.worldGeneratorProvider.getAllGenerators());
            case "-s" -> Collections.singletonList(String.valueOf(new Random().nextLong()));
            case "-t" -> WorldType.toStringList();
            default -> Collections.emptyList();
        };
    }
}

