/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.util.Booleans;
import com.dev7ex.common.util.Numbers;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.event.world.WorldGameRuleChangeEvent;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="gamerule", permission="multiworld.command.world.gamerule")
public class GameRuleCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldProvider worldProvider;

    public GameRuleCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldProvider = plugin.getWorldProvider();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length != 4) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.gamerule.usage").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        if (arguments[1].equalsIgnoreCase("%creator_name%")) {
            arguments[1] = arguments[1].replaceAll("%creator_name%", commandSender.getName());
        }
        if (this.worldProvider.getWorldHolder(arguments[1]).isEmpty()) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.world.not-exists").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[1]));
            return;
        }
        GameRule gameRule = GameRule.getByName((String)arguments[2]);
        if (gameRule == null) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.gamerule.not-existing").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%gamerule_name%", arguments[2]));
            return;
        }
        BukkitWorldHolder worldHolder = this.worldProvider.getWorldHolder(arguments[1]).orElseThrow();
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(worldHolder, commandSender, gameRule, arguments[3]);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (Numbers.isInteger((String)arguments[3]) && gameRule.getType() == Integer.class) {
            GameRule currentGameRule = gameRule;
            worldHolder.getWorld().setGameRule(currentGameRule, (Object)Integer.parseInt(arguments[3]));
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.gamerule.successfully-set").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%gamerule_name%", gameRule.getName()).replaceAll("%value%", arguments[3]).replaceAll("%world_name%", arguments[1]));
            return;
        }
        if (Booleans.isBoolean((String)arguments[3]) && gameRule.getType() == Boolean.class) {
            GameRule currentGameRule = gameRule;
            worldHolder.getWorld().setGameRule(currentGameRule, (Object)Boolean.parseBoolean(arguments[3]));
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.gamerule.successfully-set").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%gamerule_name%", gameRule.getName()).replaceAll("%value%", arguments[3]).replaceAll("%world_name%", arguments[1]));
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.gamerule.invalid-value").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%gamerule_name%", arguments[2]).replaceAll("%value%", arguments[3]));
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length == 2) {
            return Lists.newArrayList(this.worldProvider.getWorldHolders().keySet());
        }
        if (arguments.length == 3) {
            return Arrays.stream(GameRule.values()).map(GameRule::getName).toList();
        }
        if (this.worldProvider.getWorldHolder(arguments[1]).isEmpty()) {
            return Collections.emptyList();
        }
        BukkitWorldHolder worldHolder = this.worldProvider.getWorldHolder(arguments[1]).get();
        GameRule gameRule = GameRule.getByName((String)arguments[2]);
        if (gameRule == null) {
            return Collections.emptyList();
        }
        if (gameRule.getType() == Boolean.class) {
            return List.of("true", "false");
        }
        return List.of(String.valueOf(worldHolder.getWorld().getGameRuleValue(gameRule)));
    }
}

