/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="list", permission="multiworld.command.world.list")
public class ListCommand
extends BukkitCommand {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldProvider worldProvider;

    public ListCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldProvider = plugin.getWorldProvider();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length != 1) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.list.usage").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> worldEntries = this.worldProvider.getWorldHolders().keySet();
        for (String worldEntry : worldEntries) {
            BukkitWorldHolder worldHolder = this.worldProvider.getWorldHolder(worldEntry).orElseThrow();
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(ChatColor.GRAY);
                stringBuilder.append(", ");
            }
            stringBuilder.append(worldHolder.isLoaded() ? ChatColor.GREEN : ChatColor.RED).append(worldEntry);
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.list.message").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_names%", stringBuilder.toString()));
    }
}

