/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.util.Colored;
import com.dev7ex.multiworld.util.PluginUpdater;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="version", permission="multiworld.command.world.version")
public class VersionCommand
extends BukkitCommand {
    private final PluginUpdater updater;
    private final PluginDescriptionFile descriptionFile;

    public VersionCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.updater = plugin.getUpdater();
        this.descriptionFile = plugin.getDescription();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        MultiWorldPlugin plugin = MultiWorldPlugin.getInstance();
        commandSender.sendMessage(" ");
        commandSender.sendMessage("\u00a7f\u00a7m                    \u00a7r\u00a7r " + super.getConfiguration().getPrefix() + " \u00a7f\u00a7m                    ");
        commandSender.sendMessage(" ");
        commandSender.sendMessage("\u00a78\u00bb \u00a7bVersion: \u00a7a" + this.descriptionFile.getVersion());
        commandSender.sendMessage("\u00a78\u00bb \u00a7bAuthors: " + this.getAuthors());
        commandSender.sendMessage("\u00a78\u00bb \u00a7bSupport: \u00a7adiscord.dev7ex.com");
        commandSender.sendMessage("\u00a78\u00bb \u00a7bWiki: \u00a7ahttps://github.com/Dev7ex/MultiWorld/wiki");
        commandSender.sendMessage("\u00a78\u00bb \u00a7bReport Bug: \u00a7ahttps://github.com/Dev7ex/MultiWorld/issues");
        commandSender.sendMessage("\u00a78\u00bb \u00a7bUpdate Available: " + Colored.getColoredBoolean(this.updater.isUpdateAvailable()));
        commandSender.sendMessage(" ");
        commandSender.sendMessage("\u00a7f\u00a7m                    \u00a7r\u00a7r " + super.getConfiguration().getPrefix() + " \u00a7f\u00a7m                    ");
        commandSender.sendMessage(" ");
    }

    private String getAuthors() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String author : this.descriptionFile.getAuthors()) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(ChatColor.GRAY);
                stringBuilder.append(", ");
            }
            stringBuilder.append(ChatColor.GREEN).append(author);
        }
        return stringBuilder.toString();
    }
}

