/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.command.world.HelpCommand;
import com.dev7ex.multiworld.command.world.whitelist.AddCommand;
import com.dev7ex.multiworld.command.world.whitelist.DisableCommand;
import com.dev7ex.multiworld.command.world.whitelist.EnableCommand;
import com.dev7ex.multiworld.command.world.whitelist.ListCommand;
import com.dev7ex.multiworld.command.world.whitelist.RemoveCommand;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BukkitCommandProperties(name="whitelist", permission="multiworld.command.world.whitelist")
public class WhitelistCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldProvider worldProvider;

    public WhitelistCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldProvider = plugin.getWorldProvider();
        super.registerSubCommand((BukkitCommand)new AddCommand(plugin));
        super.registerSubCommand((BukkitCommand)new DisableCommand(plugin));
        super.registerSubCommand((BukkitCommand)new EnableCommand(plugin));
        super.registerSubCommand((BukkitCommand)new HelpCommand(plugin));
        super.registerSubCommand((BukkitCommand)new ListCommand(plugin));
        super.registerSubCommand((BukkitCommand)new RemoveCommand(plugin));
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length < 3 || arguments.length > 4) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.whitelist.usage").replaceAll("%prefix%", super.getConfiguration().getPrefix()));
            return;
        }
        if (this.worldProvider.getWorldHolder(arguments[1]).isEmpty()) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "general.world.not-exists").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[1]));
            return;
        }
        if (super.getSubCommand(arguments[2].toLowerCase()).isEmpty()) {
            Objects.requireNonNull(super.getSubCommand(HelpCommand.class)).execute(commandSender, arguments);
            return;
        }
        ((BukkitCommand)super.getSubCommand(arguments[2].toLowerCase()).get()).execute(commandSender, arguments);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        if (arguments.length < 2 || arguments.length > 4) {
            return Collections.emptyList();
        }
        if (arguments.length == 2) {
            return new ArrayList<String>(this.worldProvider.getWorldHolders().keySet());
        }
        if (arguments.length == 3) {
            return Lists.newArrayList(super.getSubCommands().keySet());
        }
        if (super.getSubCommand(arguments[2].toLowerCase()).isEmpty()) {
            return Collections.emptyList();
        }
        BukkitCommand subCommand = (BukkitCommand)super.getSubCommand(arguments[2].toLowerCase()).get();
        if (!(subCommand instanceof BukkitTabCompleter)) {
            return Collections.emptyList();
        }
        return ((BukkitTabCompleter)subCommand).onTabComplete(commandSender, arguments);
    }
}

