/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.command.world.whitelist;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandProperties;
import com.dev7ex.common.bukkit.command.completer.BukkitTabCompleter;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldConfiguration;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@BukkitCommandProperties(name="list", permission="multiworld.command.whitelist.list")
public class ListCommand
extends BukkitCommand
implements BukkitTabCompleter {
    private final DefaultTranslationProvider translationProvider;
    private final DefaultWorldConfiguration worldConfiguration;
    private final DefaultWorldProvider worldProvider;

    public ListCommand(@NotNull MultiWorldPlugin plugin) {
        super((BukkitPlugin)plugin);
        this.translationProvider = plugin.getTranslationProvider();
        this.worldConfiguration = plugin.getWorldConfiguration();
        this.worldProvider = plugin.getWorldProvider();
    }

    public void execute(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        BukkitWorldHolder worldHolder = this.worldProvider.getWorldHolder(arguments[1]).orElseThrow();
        if (worldHolder.getWhitelist().isEmpty()) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.whitelist.list.empty").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[1]));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String name : worldHolder.getWhitelist()) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(ChatColor.GRAY);
                stringBuilder.append(", ");
            }
            stringBuilder.append(Bukkit.getPlayer((String)name) != null ? ChatColor.GREEN : ChatColor.RED).append(name);
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.whitelist.list.message").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", arguments[1]).replaceAll("%player_names%", stringBuilder.toString()));
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull String[] arguments) {
        return Collections.emptyList();
    }
}

