/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.hook.placeholder;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import java.util.Optional;
import lombok.Generated;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderHook
extends PlaceholderExpansion {
    private final String identifier = "multiworld";
    private final String author = "Dev7ex";
    private final String version = "1.0.0";
    private final String requiredPlugin = "MultiWorld";
    private final MultiWorldBukkitApi multiWorldApi;

    public PlaceholderHook(@NotNull MultiWorldBukkitApi multiWorldApi) {
        this.multiWorldApi = multiWorldApi;
    }

    public boolean register() {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return false;
        }
        return super.register();
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String parameter) {
        return this.onPlaceholderRequest(parameter);
    }

    @Nullable
    private String onPlaceholderRequest(@NotNull String parameter) {
        Optional<Type> typeOptional = Type.getByParameter(parameter);
        if (typeOptional.isEmpty()) {
            return null;
        }
        Type type = typeOptional.get();
        Optional optional = this.multiWorldApi.getWorldProvider().getWorldHolder(parameter.replaceAll(type.getParameter(), ""));
        if (optional.isEmpty()) {
            return "world-not-exists";
        }
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)optional.get();
        if (type.isRequiresLoadedWorld() && !worldHolder.isLoaded()) {
            return "world-not-loaded";
        }
        switch (type.ordinal()) {
            case 0: {
                return String.valueOf(worldHolder.getWorld().getEntities().stream().filter(entity -> entity.getType() == EntityType.PLAYER).count());
            }
            case 1: {
                return worldHolder.getGameMode().name();
            }
            case 2: {
                return worldHolder.getDifficulty().name();
            }
            case 3: {
                return String.valueOf(worldHolder.isSpawnAnimals());
            }
            case 4: {
                return String.valueOf(worldHolder.isSpawnMonsters());
            }
            case 6: {
                return String.valueOf((Object)worldHolder.getType());
            }
            case 5: {
                return String.valueOf(worldHolder.isPvpEnabled());
            }
        }
        return null;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getRequiredPlugin() {
        return this.requiredPlugin;
    }

    @Generated
    public MultiWorldBukkitApi getMultiWorldApi() {
        return this.multiWorldApi;
    }

    public static enum Type {
        PLAYER_COUNT("_player_count", true),
        GAME_MODE("_game_mode", false),
        DIFFICULTY("_difficulty", false),
        SPAWN_ANIMALS("_spawn_animals", false),
        SPAWN_MONSTERS("_spawn_monsters", false),
        PVP_ENABLED("_pvp-enabled", false),
        TYPE("_type", false);

        private final String parameter;
        private final boolean requiresLoadedWorld;

        private Type(String parameter, boolean requiresLoadedWorld) {
            this.parameter = parameter;
            this.requiresLoadedWorld = requiresLoadedWorld;
        }

        public static Optional<Type> getByParameter(@NotNull String parameter) {
            for (Type type : Type.values()) {
                if (!parameter.contains(type.getParameter())) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }

        @Generated
        public String getParameter() {
            return this.parameter;
        }

        @Generated
        public boolean isRequiresLoadedWorld() {
            return this.requiresLoadedWorld;
        }
    }
}

