/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.entity;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPortalEvent;
import org.jetbrains.annotations.NotNull;

public class EntityPortalListener
extends MultiWorldListener {
    public EntityPortalListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleEntityEnterPortal(EntityPortalEvent event) {
        if (!super.getConfiguration().isWorldLinkEnabled()) {
            return;
        }
        if (event.getFrom().getWorld() == null) {
            return;
        }
        if (super.getWorldProvider().getWorldHolder(event.getFrom().getWorld().getName()).isEmpty()) {
            return;
        }
        BukkitWorldHolder fromWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(event.getFrom().getWorld().getName()).get();
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            return;
        }
        switch (event.getTo().getWorld().getEnvironment()) {
            case NETHER: {
                if (fromWorldHolder.getNetherWorldName() == null) {
                    event.setCancelled(true);
                    return;
                }
                if (super.getWorldProvider().getWorldHolder(fromWorldHolder.getNetherWorldName()).isEmpty()) {
                    event.setCancelled(true);
                    return;
                }
                BukkitWorldHolder netherWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(fromWorldHolder.getNetherWorldName()).get();
                if (!netherWorldHolder.isLoaded()) {
                    event.setCancelled(true);
                    return;
                }
                event.getTo().setWorld(netherWorldHolder.getWorld());
                break;
            }
            case NORMAL: {
                if (fromWorldHolder.getNormalWorldName() == null) {
                    event.setCancelled(true);
                    return;
                }
                if (super.getWorldProvider().getWorldHolder(fromWorldHolder.getNormalWorldName()).isEmpty()) {
                    event.setCancelled(true);
                    return;
                }
                BukkitWorldHolder normalWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(fromWorldHolder.getNormalWorldName()).get();
                if (!normalWorldHolder.isLoaded()) {
                    event.setCancelled(true);
                    return;
                }
                event.getTo().setWorld(normalWorldHolder.getWorld());
                break;
            }
            case THE_END: {
                if (fromWorldHolder.getEndWorldName() == null) {
                    event.setCancelled(true);
                    return;
                }
                if (super.getWorldProvider().getWorldHolder(fromWorldHolder.getEndWorldName()).isEmpty()) {
                    event.setCancelled(true);
                    return;
                }
                BukkitWorldHolder endWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(fromWorldHolder.getEndWorldName()).get();
                if (!endWorldHolder.isLoaded()) {
                    event.setCancelled(true);
                    return;
                }
                event.getTo().setWorld(endWorldHolder.getWorld());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerEnterBlockPortal(EntityPortalEvent event) {
        if (event.getFrom().getWorld() == null) {
            return;
        }
        BukkitWorldHolder fromWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(event.getFrom().getWorld().getName()).orElseThrow();
        if (event.getTo() == null) {
            return;
        }
        if (event.getTo().getWorld() == null) {
            return;
        }
        switch (event.getTo().getWorld().getEnvironment()) {
            case NETHER: {
                if (fromWorldHolder.isNetherPortalAccessible()) {
                    return;
                }
                event.setCancelled(true);
                break;
            }
            case THE_END: {
                if (fromWorldHolder.isEndPortalAccessible()) {
                    return;
                }
                event.setCancelled(true);
            }
        }
    }
}

