/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.entity;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.jetbrains.annotations.NotNull;

public class EntitySpawnListener
extends MultiWorldListener {
    public EntitySpawnListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleEntitySpawn(EntitySpawnEvent event) {
        if (event.getLocation().getWorld() == null) {
            return;
        }
        String worldName = event.getLocation().getWorld().getName();
        if (super.getWorldProvider().getWorldHolder(worldName).isEmpty()) {
            return;
        }
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(worldName).get();
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!worldHolder.isSpawnEntities()) {
            event.setCancelled(true);
        }
    }
}

