/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.player;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerAdvancementDoneListener
extends MultiWorldListener {
    public PlayerAdvancementDoneListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerAdvancementDone(PlayerAdvancementDoneEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(world.getName()).orElseThrow();
        if (worldHolder.isReceiveAchievements()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        AdvancementProgress progress = player.getAdvancementProgress(advancement);
        if (progress.isDone()) {
            progress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).revokeCriteria(arg_0));
        }
    }
}

