/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.player;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.event.user.WorldUserTeleportWorldEvent;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerChangeWorldListener
extends MultiWorldListener {
    public PlayerChangeWorldListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World to = event.getTo() != null ? event.getTo().getWorld() : null;
        World from = event.getFrom().getWorld();
        if (to == null || from == null) {
            return;
        }
        if (from.getName().equalsIgnoreCase(to.getName())) {
            return;
        }
        if (super.getWorldProvider().getWorldHolder(to.getName()).isEmpty() || super.getWorldProvider().getWorldHolder(from.getName()).isEmpty()) {
            return;
        }
        BukkitWorldHolder lastWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(from.getName()).get();
        BukkitWorldHolder nextWorldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(to.getName()).get();
        if (super.getUserProvider().getUser(player.getUniqueId()).isEmpty()) {
            return;
        }
        BukkitWorldUser user = (BukkitWorldUser)super.getUserProvider().getUser(player.getUniqueId()).get();
        Bukkit.getPluginManager().callEvent((Event)new WorldUserTeleportWorldEvent(user, lastWorldHolder, nextWorldHolder));
    }
}

