/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.player;

import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.event.user.WorldUserLoginEvent;
import com.dev7ex.multiworld.api.bukkit.event.user.WorldUserLogoutEvent;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.user.WorldUserProperty;
import com.dev7ex.multiworld.api.world.location.WorldLocation;
import com.dev7ex.multiworld.user.User;
import com.dev7ex.multiworld.user.UserConfiguration;
import com.dev7ex.multiworld.util.PluginUpdater;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerConnectionListener
extends MultiWorldListener {
    public PlayerConnectionListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        User user = new User(player.getUniqueId(), player.getName());
        UserConfiguration userConfiguration = new UserConfiguration(user);
        ParsedMap<WorldUserProperty, Object> userData = userConfiguration.read();
        user.setLastLocation((WorldLocation)userData.getValue((Object)WorldUserProperty.LAST_LOCATION));
        user.setFirstLogin(userData.getLong((Object)WorldUserProperty.FIRST_LOGIN));
        user.setLastLogin(userData.getLong((Object)WorldUserProperty.LAST_LOGIN));
        user.setConfiguration(userConfiguration);
        super.getUserProvider().registerUser(user);
        Bukkit.getPluginManager().callEvent((Event)new WorldUserLoginEvent(user));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PluginUpdater updater = MultiWorldPlugin.getInstance().getUpdater();
        if (updater.isUpdateAvailable() && player.isOp()) {
            player.sendMessage(super.getConfiguration().getPrefix() + String.valueOf(ChatColor.GRAY) + " A new update for MultiWorld is available");
            player.sendMessage(super.getConfiguration().getPrefix() + String.valueOf(ChatColor.GRAY) + " Please note that if you do not do the update then there may be problems or individual functions may be disabled");
            player.sendMessage(super.getConfiguration().getPrefix() + String.valueOf(ChatColor.GRAY) + " https://modrinth.com/plugin/multiworld-bukkit");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        BukkitWorldUser user = (BukkitWorldUser)super.getUserProvider().getUser(player.getUniqueId()).orElseThrow();
        super.getUserProvider().saveUser(user, WorldUserProperty.LAST_LOGIN, WorldUserProperty.LAST_LOCATION);
        super.getUserProvider().unregisterUser(player.getUniqueId());
        Bukkit.getPluginManager().callEvent((Event)new WorldUserLogoutEvent(user));
    }
}

