/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.player;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerDamagePlayerListener
extends MultiWorldListener {
    public PlayerDamagePlayerListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerDamagePlayer(EntityDamageByEntityEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        BukkitWorldHolder worldHolder = super.getWorldProvider().getWorldHolder(player.getWorld().getName()).orElse(null);
        if (worldHolder == null || worldHolder.isPvpEnabled()) {
            return;
        }
        if (event.getDamager() instanceof Projectile) {
            Projectile projectile = (Projectile)event.getDamager();
            if (projectile.getShooter() instanceof Player) {
                event.setCancelled(true);
            }
            return;
        }
        if (event.getDamager().getType() == EntityType.PLAYER) {
            event.setCancelled(true);
        }
    }
}

