/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.user;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.event.user.WorldUserTeleportWorldEvent;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.api.bukkit.world.location.BukkitWorldLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;

public class UserTeleportWorldListener
extends MultiWorldListener {
    public UserTeleportWorldListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUserGameModeChange(WorldUserTeleportWorldEvent event) {
        Player player = (Player)event.getUser().getEntity();
        if (!super.getConfiguration().isAutoGameModeEnabled()) {
            return;
        }
        if (event.getNextWorldHolder().getForceGameMode().equalsIgnoreCase("false")) {
            return;
        }
        if (event.getNextWorldHolder().getForceGameMode().equalsIgnoreCase("false-with-permission") && player.hasPermission("multiworld.bypass.forcegamemode")) {
            return;
        }
        player.setGameMode(event.getNextWorldHolder().getGameMode());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleUserTeleportWorld(WorldUserTeleportWorldEvent event) {
        BukkitWorldUser worldUser = event.getUser();
        Player player = (Player)event.getUser().getEntity();
        BukkitWorldHolder nextHolder = event.getNextWorldHolder();
        if (player.hasPermission("multiworld.command.world.teleport.admin")) {
            return;
        }
        if (!player.hasPermission("multiworld.command.world.teleport." + nextHolder.getName())) {
            player.sendMessage(super.getTranslationProvider().getMessage(player, "commands.world.teleport.missing-permission").replaceAll("%prefix%", super.getPrefix()).replaceAll("%world_name%", nextHolder.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleUserEnterWorld(WorldUserTeleportWorldEvent event) {
        BukkitWorldUser user = event.getUser();
        Player player = (Player)user.getEntity();
        BukkitWorldHolder nextWorldHolder = event.getNextWorldHolder();
        user.setLastLocation(BukkitWorldLocation.of(player.getLocation()));
        if (!nextWorldHolder.isWhitelistEnabled()) {
            return;
        }
        if (nextWorldHolder.getWhitelist().contains(user.getName())) {
            return;
        }
        if (player.hasPermission("multiworld.whitelist.ignore")) {
            return;
        }
        user.setLastLocation(null);
        player.sendMessage(super.getConfiguration().getString("messages.general.world-whitelist-block-trespassing").replaceAll("%prefix%", super.getConfiguration().getPrefix()).replaceAll("%world_name%", nextWorldHolder.getName()));
        event.setCancelled(true);
    }
}

