/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.listener.world;

import com.dev7ex.multiworld.api.bukkit.MultiWorldBukkitApi;
import com.dev7ex.multiworld.api.bukkit.event.MultiWorldListener;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class WorldActivityListener
extends MultiWorldListener {
    public WorldActivityListener(@NotNull MultiWorldBukkitApi multiWorldApi) {
        super(multiWorldApi);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerInteract(PlayerInteractEvent event) {
        String worldName = event.getPlayer().getWorld().getName();
        if (super.getWorldProvider().getWorldHolder(worldName).isEmpty()) {
            return;
        }
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(worldName).get();
        worldHolder.setLastActivity(System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleWorldBlockBreak(BlockBreakEvent event) {
        String worldName = event.getBlock().getWorld().getName();
        if (super.getWorldProvider().getWorldHolder(worldName).isEmpty()) {
            return;
        }
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(worldName).get();
        worldHolder.setLastActivity(System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handleWorldBlockBreak(BlockPlaceEvent event) {
        String worldName = event.getBlock().getWorld().getName();
        if (super.getWorldProvider().getWorldHolder(worldName).isEmpty()) {
            return;
        }
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)super.getWorldProvider().getWorldHolder(worldName).get();
        worldHolder.setLastActivity(System.currentTimeMillis());
    }
}

