/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.task;

import com.dev7ex.common.scheduler.task.Task;
import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.world.DefaultWorldProvider;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class WorldUnloadTask
implements Task {
    private final DefaultWorldProvider worldProvider;
    private final Queue<BukkitWorldHolder> worldUnloadQueue = new ConcurrentLinkedQueue<BukkitWorldHolder>();
    private final MultiWorldConfiguration configuration = MultiWorldPlugin.getInstance().getConfiguration();

    public WorldUnloadTask(@NotNull DefaultWorldProvider worldProvider) {
        this.worldProvider = worldProvider;
    }

    public void run() {
        BukkitWorldHolder worldToUnload;
        for (BukkitWorldHolder worldHolder : this.worldProvider.getWorldHolders().values()) {
            if (!worldHolder.isAutoUnloadEnabled() || !worldHolder.isLoaded() || System.currentTimeMillis() - worldHolder.getLoadTimeStamp() < TimeUnit.SECONDS.toMillis(this.configuration.getAutoUnloadLoadDelay())) continue;
            if (!worldHolder.getWorld().getPlayers().isEmpty()) {
                return;
            }
            if (worldHolder.getName().equalsIgnoreCase(this.configuration.getString("settings.defaults.normal-world"))) {
                return;
            }
            if (System.currentTimeMillis() - worldHolder.getLastActivity() < this.configuration.getAutoUnloadSystemDelay() * 1000L || this.worldUnloadQueue.contains(worldHolder)) continue;
            this.worldUnloadQueue.add(worldHolder);
        }
        if (!this.worldUnloadQueue.isEmpty() && (worldToUnload = this.worldUnloadQueue.poll()) != null) {
            this.worldProvider.getWorldManager().unloadWorld(Bukkit.getConsoleSender().getName(), worldToUnload.getName());
        }
    }
}

