/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.translation;

import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.module.PluginModule;
import com.dev7ex.common.io.file.Files;
import com.dev7ex.common.io.file.configuration.ConfigurationProvider;
import com.dev7ex.common.io.file.configuration.FileConfiguration;
import com.dev7ex.common.io.file.configuration.JsonConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.translation.BukkitTranslationProvider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DefaultTranslationProvider
implements PluginModule,
BukkitTranslationProvider {
    private final BukkitPlugin plugin;
    private final Map<Locale, FileConfiguration> translationConfigurations = new HashMap<Locale, FileConfiguration>();
    private final Locale defaultLocale = new Locale("en", "us");

    public DefaultTranslationProvider(@NotNull BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void onEnable() {
        this.plugin.saveResource("language/de_DE.json", true);
        this.plugin.saveResource("language/en_US.json", true);
        this.plugin.saveResource("language/fr_FR.json", true);
        this.plugin.saveResource("language/uk_UA.json", true);
        this.plugin.saveResource("language/tr_TR.json", true);
        this.plugin.saveResource("language/zh_CN.json", true);
        this.plugin.saveResource("language/it_IT.json", true);
        for (File file : Files.getFiles((File)this.plugin.getSubFolder("language"))) {
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            String[] parts = file.getName().replaceAll(".json", "").split("_");
            Locale locale = new Locale(parts[0], parts[1]);
            try {
                FileConfiguration nextConfiguration = ConfigurationProvider.getProvider(JsonConfiguration.class).load(file);
                this.translationConfigurations.put(locale, nextConfiguration);
            }
            catch (IOException exception) {
                this.plugin.getLogger().warning("Can't load configuration File for Locale " + String.valueOf(locale));
                exception.printStackTrace();
            }
        }
        MultiWorldPlugin.getInstance().getLogger().info("Found: [" + this.translationConfigurations.size() + "] Translations");
    }

    public void onDisable() {
        this.translationConfigurations.clear();
    }

    @Override
    public void register(@NotNull Locale locale, @NotNull File file) {
        try {
            FileConfiguration configuration = ConfigurationProvider.getProvider(JsonConfiguration.class).load(file);
            this.translationConfigurations.put(locale, configuration);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void unregister(@NotNull Locale locale) {
        this.translationConfigurations.remove(locale);
    }

    @Override
    public String getMessage(@NotNull CommandSender entity, @NotNull String path) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String[] parts = player.getLocale().split("_");
            Locale locale = new Locale(parts[0], parts[1]);
            return this.translationConfigurations.getOrDefault(locale, this.translationConfigurations.get(this.defaultLocale)).getString(path);
        }
        return this.translationConfigurations.get(this.defaultLocale).getString(path);
    }

    @Override
    public List<String> getMessageList(@NotNull CommandSender entity, @NotNull String path) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String[] parts = player.getLocale().split("_");
            Locale locale = new Locale(parts[0], parts[1]);
            return this.translationConfigurations.getOrDefault(locale, this.translationConfigurations.get(this.defaultLocale)).getStringList(path);
        }
        return this.translationConfigurations.get(this.defaultLocale).getStringList(path);
    }

    @Generated
    public BukkitPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public Map<Locale, FileConfiguration> getTranslationConfigurations() {
        return this.translationConfigurations;
    }

    @Override
    @Generated
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

