/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.user;

import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.bukkit.world.location.BukkitWorldLocation;
import com.dev7ex.multiworld.api.user.WorldUserConfiguration;
import com.dev7ex.multiworld.api.world.WorldHolder;
import com.dev7ex.multiworld.api.world.location.WorldLocation;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class User
implements BukkitWorldUser {
    private final UUID uniqueId;
    private final String name;
    private WorldUserConfiguration configuration;
    private WorldLocation lastLocation;
    private long firstLogin;
    private long lastLogin;

    public User(@NotNull UUID uniqueId, @NotNull String name) {
        this.uniqueId = uniqueId;
        this.name = name;
    }

    @Override
    public void sendMessage(@NotNull String message) {
        this.getEntity().sendMessage(message);
    }

    @Override
    public void teleport(@NotNull WorldHolder worldHolder) {
        this.getEntity().teleport(BukkitWorldLocation.to(worldHolder.getSpawnLocation()), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public Player getEntity() {
        return Bukkit.getPlayer((UUID)this.uniqueId);
    }

    @Override
    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public WorldUserConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Generated
    public WorldLocation getLastLocation() {
        return this.lastLocation;
    }

    @Override
    @Generated
    public long getFirstLogin() {
        return this.firstLogin;
    }

    @Override
    @Generated
    public long getLastLogin() {
        return this.lastLogin;
    }

    @Override
    @Generated
    public void setConfiguration(WorldUserConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public void setLastLocation(WorldLocation lastLocation) {
        this.lastLocation = lastLocation;
    }

    @Override
    @Generated
    public void setFirstLogin(long firstLogin) {
        this.firstLogin = firstLogin;
    }

    @Override
    @Generated
    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }
}

