/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.user;

import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.common.io.file.configuration.ConfigurationProvider;
import com.dev7ex.common.io.file.configuration.FileConfiguration;
import com.dev7ex.common.io.file.configuration.JsonConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUserConfiguration;
import com.dev7ex.multiworld.api.bukkit.world.location.BukkitWorldLocation;
import com.dev7ex.multiworld.api.user.WorldUserProperty;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class UserConfiguration
implements BukkitWorldUserConfiguration {
    private final File configurationFile;
    private final FileConfiguration fileConfiguration;

    public UserConfiguration(@NotNull BukkitWorldUser user) {
        this.configurationFile = new File(String.valueOf(MultiWorldPlugin.getInstance().getSubFolder("user")) + File.separator + user.getUniqueId().toString() + ".json");
        if (!this.configurationFile.exists()) {
            this.configurationFile.createNewFile();
        }
        this.fileConfiguration = ConfigurationProvider.getProvider(JsonConfiguration.class).load(this.configurationFile);
        this.fileConfiguration.addDefault(WorldUserProperty.UNIQUE_ID.getStoragePath(), (Object)user.getUniqueId().toString());
        this.fileConfiguration.addDefault(WorldUserProperty.NAME.getStoragePath(), (Object)user.getName());
        this.fileConfiguration.addDefault(WorldUserProperty.LAST_LOCATION.getStoragePath(), null);
        this.fileConfiguration.addDefault(WorldUserProperty.FIRST_LOGIN.getStoragePath(), (Object)System.currentTimeMillis());
        this.fileConfiguration.addDefault(WorldUserProperty.LAST_LOGIN.getStoragePath(), (Object)System.currentTimeMillis());
        this.save();
    }

    @Override
    public ParsedMap<WorldUserProperty, Object> read() {
        ParsedMap userData = new ParsedMap();
        Arrays.stream(WorldUserProperty.values()).forEach(property -> {
            switch (property) {
                case UNIQUE_ID: {
                    userData.put((Object)property, (Object)UUID.fromString(Objects.requireNonNull(this.fileConfiguration.getString(property.getStoragePath()))));
                    break;
                }
                case NAME: {
                    userData.put((Object)property, (Object)this.fileConfiguration.getString(property.getStoragePath()));
                    break;
                }
                case LAST_LOCATION: {
                    userData.put((Object)property, (Object)BukkitWorldLocation.builder().setWorldName(this.fileConfiguration.getString(property.getStoragePath() + ".world")).setX(this.fileConfiguration.getDouble(property.getStoragePath() + ".x")).setY(this.fileConfiguration.getDouble(property.getStoragePath() + ".y")).setZ(this.fileConfiguration.getDouble(property.getStoragePath() + ".z")).setPitch(this.fileConfiguration.getDouble(property.getStoragePath() + ".pitch")).setYaw(this.fileConfiguration.getDouble(property.getStoragePath() + ".yaw")).build());
                    break;
                }
                case FIRST_LOGIN: 
                case LAST_LOGIN: {
                    userData.put((Object)property, (Object)this.fileConfiguration.getLong(property.getStoragePath(), System.currentTimeMillis()));
                }
            }
        });
        return userData;
    }

    @Override
    public ParsedMap<WorldUserProperty, Object> read(WorldUserProperty ... properties) {
        if (properties == null) {
            return this.read();
        }
        ParsedMap userData = new ParsedMap();
        block6: for (WorldUserProperty property : properties) {
            switch (property) {
                case UNIQUE_ID: {
                    userData.put((Object)property, (Object)UUID.fromString(Objects.requireNonNull(this.fileConfiguration.getString(property.getStoragePath()))));
                    continue block6;
                }
                case NAME: {
                    userData.put((Object)property, (Object)this.fileConfiguration.getString(property.getStoragePath()));
                    continue block6;
                }
                case LAST_LOCATION: {
                    userData.put((Object)property, (Object)BukkitWorldLocation.builder().setWorldName(this.fileConfiguration.getString(property.getStoragePath() + ".world")).setX(this.fileConfiguration.getDouble(property.getStoragePath() + ".x")).setY(this.fileConfiguration.getDouble(property.getStoragePath() + ".y")).setZ(this.fileConfiguration.getDouble(property.getStoragePath() + ".z")).setPitch(this.fileConfiguration.getDouble(property.getStoragePath() + ".pitch")).setYaw(this.fileConfiguration.getDouble(property.getStoragePath() + ".yaw")).build());
                    continue block6;
                }
                case FIRST_LOGIN: 
                case LAST_LOGIN: {
                    userData.put((Object)property, (Object)this.fileConfiguration.getLong(property.getStoragePath()));
                    continue block6;
                }
            }
        }
        return userData;
    }

    @Override
    public void write(ParsedMap<WorldUserProperty, Object> userData) {
        for (WorldUserProperty property : userData.keySet()) {
            switch (property) {
                case UNIQUE_ID: {
                    this.fileConfiguration.set(property.getStoragePath(), (Object)userData.getUUID((Object)property).toString());
                    break;
                }
                case NAME: {
                    this.fileConfiguration.set(property.getStoragePath(), (Object)userData.getString((Object)property));
                    break;
                }
                case LAST_LOCATION: {
                    BukkitWorldLocation worldLocation = (BukkitWorldLocation)userData.getValue((Object)property);
                    this.fileConfiguration.set(property.getStoragePath() + ".world", (Object)worldLocation.getWorldName());
                    this.fileConfiguration.set(property.getStoragePath() + ".x", (Object)worldLocation.getX());
                    this.fileConfiguration.set(property.getStoragePath() + ".y", (Object)worldLocation.getY());
                    this.fileConfiguration.set(property.getStoragePath() + ".z", (Object)worldLocation.getZ());
                    this.fileConfiguration.set(property.getStoragePath() + ".pitch", (Object)worldLocation.getPitch());
                    this.fileConfiguration.set(property.getStoragePath() + ".yaw", (Object)worldLocation.getYaw());
                    break;
                }
                case FIRST_LOGIN: 
                case LAST_LOGIN: {
                    this.fileConfiguration.set(property.getStoragePath(), (Object)userData.getLong((Object)property));
                }
            }
        }
        this.save();
    }

    @Override
    public void save() {
        ConfigurationProvider.getProvider(JsonConfiguration.class).save(this.fileConfiguration, this.configurationFile);
    }
}

