/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.user;

import com.dev7ex.common.bukkit.plugin.module.PluginModule;
import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUser;
import com.dev7ex.multiworld.api.bukkit.user.BukkitWorldUserProvider;
import com.dev7ex.multiworld.api.user.WorldUserProperty;
import com.dev7ex.multiworld.api.world.location.WorldLocation;
import com.dev7ex.multiworld.user.User;
import com.dev7ex.multiworld.user.UserConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UserProvider
implements PluginModule,
BukkitWorldUserProvider {
    private final Map<UUID, BukkitWorldUser> users = new HashMap<UUID, BukkitWorldUser>();

    public void onEnable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            User user = new User(player.getUniqueId(), player.getName());
            UserConfiguration userConfiguration = new UserConfiguration(user);
            ParsedMap<WorldUserProperty, Object> userData = userConfiguration.read();
            user.setFirstLogin(userData.getLong((Object)WorldUserProperty.FIRST_LOGIN));
            user.setLastLogin(userData.getLong((Object)WorldUserProperty.LAST_LOGIN));
            user.setLastLocation((WorldLocation)userData.getValue((Object)WorldUserProperty.LAST_LOCATION));
            user.setConfiguration(userConfiguration);
            this.registerUser(user);
        }
    }

    public void onDisable() {
        for (BukkitWorldUser user : this.users.values()) {
            this.saveUser(user, WorldUserProperty.LAST_LOCATION, WorldUserProperty.LAST_LOGIN);
        }
        this.users.clear();
    }

    @Override
    public void registerUser(@NotNull BukkitWorldUser user) {
        this.users.put(user.getUniqueId(), user);
    }

    @Override
    public void unregisterUser(@NotNull UUID uniqueId) {
        this.users.remove(uniqueId);
    }

    @Override
    public Optional<BukkitWorldUser> getUser(@NotNull UUID uniqueId) {
        return Optional.ofNullable(this.users.get(uniqueId));
    }

    @Override
    public Optional<BukkitWorldUser> getUser(@NotNull String name) {
        return this.users.values().stream().filter(user -> user.getName().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    public void saveUser(@NotNull BukkitWorldUser user) {
        this.saveUser(user, WorldUserProperty.UNIQUE_ID, WorldUserProperty.NAME, WorldUserProperty.LAST_LOCATION, WorldUserProperty.FIRST_LOGIN, WorldUserProperty.LAST_LOGIN);
    }

    @Override
    public void saveUser(@NotNull BukkitWorldUser user, WorldUserProperty ... properties) {
        ParsedMap data = new ParsedMap();
        block7: for (WorldUserProperty property : properties) {
            switch (property) {
                case UNIQUE_ID: {
                    data.put((Object)property, (Object)user.getUniqueId());
                    continue block7;
                }
                case NAME: {
                    data.put((Object)property, (Object)user.getName());
                    continue block7;
                }
                case LAST_LOCATION: {
                    data.put((Object)property, (Object)user.getLastLocation());
                    continue block7;
                }
                case FIRST_LOGIN: {
                    data.put((Object)property, (Object)user.getFirstLogin());
                    continue block7;
                }
                case LAST_LOGIN: {
                    data.put((Object)property, (Object)user.getLastLogin());
                    continue block7;
                }
                default: {
                    this.saveUser(user);
                }
            }
        }
        user.getConfiguration().write((ParsedMap<WorldUserProperty, Object>)data);
    }

    @Override
    @Generated
    public Map<UUID, BukkitWorldUser> getUsers() {
        return this.users;
    }
}

