/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.util;

import com.dev7ex.multiworld.MultiWorldPlugin;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PluginUpdater {
    private final MultiWorldPlugin plugin;
    private volatile boolean updateAvailable = false;
    private volatile String newVersion;

    public PluginUpdater(@NotNull MultiWorldPlugin plugin) {
        this.plugin = plugin;
    }

    public void checkAsync() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block16: {
                try {
                    String repoOwner = "Dev7ex";
                    String repoName = "MultiWorld";
                    String apiUrl = "https://api.github.com/repos/Dev7ex/MultiWorld/releases/latest";
                    HttpURLConnection connection = (HttpURLConnection)new URL("https://api.github.com/repos/Dev7ex/MultiWorld/releases/latest").openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                    if (connection.getResponseCode() != 200) break block16;
                    try (InputStream inputStream = connection.getInputStream();
                         InputStreamReader reader = new InputStreamReader(inputStream);){
                        JsonObject jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                        this.newVersion = jsonObject.get("tag_name").getAsString();
                        String currentVersion = this.plugin.getDescription().getVersion();
                        if (this.compareVersions(currentVersion, this.newVersion) == -1) {
                            this.updateAvailable = true;
                            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::logUpdateMessage);
                        } else if (this.compareVersions(currentVersion, this.newVersion) == 1) {
                            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::logNoUpdateMessage);
                        }
                    }
                }
                catch (IOException exception) {
                    this.updateAvailable = false;
                }
            }
        });
    }

    public int compareVersions(@NotNull String currentVersion, @NotNull String onlineVersion) {
        String[] currentParts = currentVersion.replace("-SNAPSHOT", "").split("\\.");
        String[] onlineParts = onlineVersion.replace("-SNAPSHOT", "").split("\\.");
        for (int i = 0; i < Math.max(currentParts.length, onlineParts.length); ++i) {
            int onlinePart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = onlinePart = i < onlineParts.length ? Integer.parseInt(onlineParts[i]) : 0;
            if (currentPart < onlinePart) {
                return -1;
            }
            if (currentPart <= onlinePart) continue;
            return 1;
        }
        return 0;
    }

    public void logUpdateMessage() {
        ConsoleCommandSender commandSender = Bukkit.getConsoleSender();
        String prefix = this.plugin.getConfiguration().getPrefix();
        commandSender.sendMessage(prefix + "\u00a77There is a new update for MultiWorld available on \u00a7aModrinth");
        commandSender.sendMessage(prefix + "\u00a7cPlease update to ensure full functionality");
        commandSender.sendMessage(prefix + "\u00a77Current Version: \u00a7c" + this.plugin.getDescription().getVersion());
        commandSender.sendMessage(prefix + "\u00a77New Version: \u00a7a" + this.newVersion);
        commandSender.sendMessage(prefix + "\u00a77Download: \u00a7a" + this.plugin.getDescription().getWebsite());
    }

    public void logNoUpdateMessage() {
        ConsoleCommandSender commandSender = Bukkit.getConsoleSender();
        String prefix = this.plugin.getConfiguration().getPrefix();
        commandSender.sendMessage(prefix + " \u00a77Your \u00a7bMultiWorld \u00a77version is up to date");
        commandSender.sendMessage(prefix + " \u00a77Version: \u00a7a" + this.plugin.getDescription().getVersion());
        commandSender.sendMessage(prefix + " \u00a77URL: \u00a7a" + this.plugin.getDescription().getWebsite());
    }

    @Generated
    public MultiWorldPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }
}

